/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.protocoltests.traits.AppliesTo;
import software.amazon.smithy.protocoltests.traits.HttpRequestTestCase;
import software.amazon.smithy.utils.ListUtils;

public final class HttpRequestTestsTrait
extends AbstractTrait {
    public static final ShapeId ID = ShapeId.from((String)"smithy.test#httpRequestTests");
    private final List<HttpRequestTestCase> testCases;

    public HttpRequestTestsTrait(List<HttpRequestTestCase> testCases) {
        this(SourceLocation.NONE, testCases);
    }

    public HttpRequestTestsTrait(SourceLocation sourceLocation, List<HttpRequestTestCase> testCases) {
        super(ID, (FromSourceLocation)sourceLocation);
        this.testCases = ListUtils.copyOf(testCases);
    }

    public List<HttpRequestTestCase> getTestCases() {
        return this.testCases;
    }

    public List<HttpRequestTestCase> getTestCasesFor(AppliesTo appliesTo) {
        return this.testCases.stream().filter(test -> !test.getAppliesTo().filter(value -> value != appliesTo).isPresent()).collect(Collectors.toList());
    }

    protected Node createNode() {
        return (Node)this.getTestCases().stream().collect(ArrayNode.collect());
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ArrayNode values = value.expectArrayNode();
            List testCases = values.getElementsAs(HttpRequestTestCase::fromNode);
            return new HttpRequestTestsTrait(value.getSourceLocation(), testCases);
        }
    }
}

