/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.protocoltests.traits.HttpMessageTestCase;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class HttpRequestTestCase
extends HttpMessageTestCase
implements ToSmithyBuilder<HttpRequestTestCase> {
    private static final String METHOD = "method";
    private static final String URI = "uri";
    private static final String HOST = "host";
    private static final String RESOLVED_HOST = "resolvedHost";
    private static final String QUERY_PARAMS = "queryParams";
    private static final String FORBID_QUERY_PARAMS = "forbidQueryParams";
    private static final String REQUIRE_QUERY_PARAMS = "requireQueryParams";
    private final String method;
    private final String uri;
    private final String host;
    private final String resolvedHost;
    private final List<String> queryParams;
    private final List<String> forbidQueryParams;
    private final List<String> requireQueryParams;

    private HttpRequestTestCase(Builder builder) {
        super(builder);
        this.method = (String)SmithyBuilder.requiredState((String)METHOD, (Object)builder.method);
        this.uri = (String)SmithyBuilder.requiredState((String)URI, (Object)builder.uri);
        this.host = builder.host;
        this.resolvedHost = builder.resolvedHost;
        this.queryParams = ListUtils.copyOf((Collection)builder.queryParams);
        this.forbidQueryParams = ListUtils.copyOf((Collection)builder.forbidQueryParams);
        this.requireQueryParams = ListUtils.copyOf((Collection)builder.requireQueryParams);
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public Optional<String> getHost() {
        return Optional.ofNullable(this.host);
    }

    public Optional<String> getResolvedHost() {
        return Optional.ofNullable(this.resolvedHost);
    }

    public List<String> getQueryParams() {
        return this.queryParams;
    }

    public List<String> getForbidQueryParams() {
        return this.forbidQueryParams;
    }

    public List<String> getRequireQueryParams() {
        return this.requireQueryParams;
    }

    public static HttpRequestTestCase fromNode(Node node) {
        Builder builder = HttpRequestTestCase.builder();
        HttpRequestTestCase.updateBuilderFromNode(builder, node);
        ObjectNode o = node.expectObjectNode();
        builder.method(o.expectStringMember(METHOD).getValue());
        builder.uri(o.expectStringMember(URI).getValue());
        o.getStringMember(HOST).ifPresent(stringNode -> builder.host(stringNode.getValue()));
        o.getStringMember(RESOLVED_HOST).ifPresent(stringNode -> builder.resolvedHost(stringNode.getValue()));
        o.getArrayMember(QUERY_PARAMS).ifPresent(queryParams -> builder.queryParams(queryParams.getElementsAs(StringNode::getValue)));
        o.getArrayMember(FORBID_QUERY_PARAMS).ifPresent(params -> builder.forbidQueryParams(params.getElementsAs(StringNode::getValue)));
        o.getArrayMember(REQUIRE_QUERY_PARAMS).ifPresent(params -> builder.requireQueryParams(params.getElementsAs(StringNode::getValue)));
        return builder.build();
    }

    @Override
    public Node toNode() {
        ObjectNode.Builder node = super.toNode().expectObjectNode().toBuilder();
        node.withMember(METHOD, this.getMethod());
        node.withMember(URI, this.getUri());
        node.withOptionalMember(HOST, this.getHost().map(Node::from));
        node.withOptionalMember(RESOLVED_HOST, this.getResolvedHost().map(Node::from));
        if (!this.queryParams.isEmpty()) {
            node.withMember(QUERY_PARAMS, (ToNode)ArrayNode.fromStrings(this.getQueryParams()));
        }
        if (!this.forbidQueryParams.isEmpty()) {
            node.withMember(FORBID_QUERY_PARAMS, (ToNode)ArrayNode.fromStrings(this.getForbidQueryParams()));
        }
        if (!this.requireQueryParams.isEmpty()) {
            node.withMember(REQUIRE_QUERY_PARAMS, (ToNode)ArrayNode.fromStrings(this.getRequireQueryParams()));
        }
        return node.build();
    }

    public Builder toBuilder() {
        Builder builder = HttpRequestTestCase.builder().method(this.getMethod()).uri(this.getUri()).queryParams(this.getQueryParams()).forbidQueryParams(this.getForbidQueryParams()).requireQueryParams(this.getRequireQueryParams());
        this.getHost().ifPresent(builder::host);
        this.getResolvedHost().ifPresent(builder::resolvedHost);
        this.updateBuilder(builder);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends HttpMessageTestCase.Builder<Builder, HttpRequestTestCase> {
        private String method;
        private String uri;
        private String host;
        private String resolvedHost;
        private final List<String> queryParams = new ArrayList<String>();
        private final List<String> forbidQueryParams = new ArrayList<String>();
        private final List<String> requireQueryParams = new ArrayList<String>();

        private Builder() {
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder resolvedHost(String resolvedHost) {
            this.resolvedHost = resolvedHost;
            return this;
        }

        public Builder queryParams(List<String> queryParams) {
            this.queryParams.clear();
            this.queryParams.addAll(queryParams);
            return this;
        }

        public Builder forbidQueryParams(List<String> forbidQueryParams) {
            this.forbidQueryParams.clear();
            this.forbidQueryParams.addAll(forbidQueryParams);
            return this;
        }

        public Builder requireQueryParams(List<String> requireQueryParams) {
            this.requireQueryParams.clear();
            this.requireQueryParams.addAll(requireQueryParams);
            return this;
        }

        public HttpRequestTestCase build() {
            return new HttpRequestTestCase(this);
        }
    }
}

