/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.CallbackObject;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.ExternalDocumentation;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.openapi.model.ServerObject;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class OperationObject
extends Component
implements ToSmithyBuilder<OperationObject> {
    private final String summary;
    private final String description;
    private final ExternalDocumentation externalDocs;
    private final String operationId;
    private final RequestBodyObject requestBody;
    private final boolean deprecated;
    private final List<String> tags;
    private final List<ParameterObject> parameters;
    private final Map<String, ResponseObject> responses;
    private final Map<String, CallbackObject> callbacks;
    private final List<Map<String, List<String>>> security;
    private final List<ServerObject> servers;

    private OperationObject(Builder builder) {
        super(builder);
        this.tags = (List)builder.tags.copy();
        this.summary = builder.summary;
        this.description = builder.description;
        this.externalDocs = builder.externalDocs;
        this.operationId = builder.operationId;
        this.parameters = (List)builder.parameters.copy();
        this.requestBody = builder.requestBody;
        this.responses = (Map)builder.responses.copy();
        this.deprecated = builder.deprecated;
        this.callbacks = (Map)builder.callbacks.copy();
        this.security = builder.security.hasValue() ? ListUtils.copyOf((Collection)((Collection)builder.security.peek())) : null;
        this.servers = (List)builder.servers.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Optional<String> getSummary() {
        return Optional.ofNullable(this.summary);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<ExternalDocumentation> getExternalDocs() {
        return Optional.ofNullable(this.externalDocs);
    }

    public Optional<String> getOperationId() {
        return Optional.ofNullable(this.operationId);
    }

    public List<ParameterObject> getParameters() {
        return this.parameters;
    }

    public Optional<RequestBodyObject> getRequestBody() {
        return Optional.ofNullable(this.requestBody);
    }

    public Map<String, ResponseObject> getResponses() {
        return this.responses;
    }

    public Map<String, CallbackObject> getCallbacks() {
        return this.callbacks;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Optional<List<Map<String, List<String>>>> getSecurity() {
        return Optional.ofNullable(this.security);
    }

    public List<ServerObject> getServers() {
        return this.servers;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("summary", this.getSummary().map(Node::from)).withOptionalMember("externalDocs", this.getExternalDocs()).withOptionalMember("operationId", this.getOperationId().map(Node::from)).withOptionalMember("requestBody", this.getRequestBody());
        if (this.isDeprecated()) {
            builder.withMember("deprecated", (ToNode)Node.from((boolean)true));
        }
        if (!this.parameters.isEmpty()) {
            builder.withMember("parameters", (ToNode)((ArrayNode)this.getParameters().stream().collect(ArrayNode.collect())));
        }
        if (!this.responses.isEmpty()) {
            builder.withMember("responses", (ToNode)((ObjectNode)this.getResponses().entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.callbacks.isEmpty()) {
            builder.withMember("callbacks", (ToNode)((ObjectNode)this.getCallbacks().entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (this.getSecurity().isPresent()) {
            builder.withMember("security", (ToNode)((ArrayNode)this.getSecurity().get().stream().map(map -> (ObjectNode)map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((ArrayNode)((List)entry.getValue()).stream().map(Node::from).collect(ArrayNode.collect())))).collect(ObjectNode.collectStringKeys(Pair::getLeft, Pair::getRight))).collect(ArrayNode.collect())));
        }
        if (!this.servers.isEmpty()) {
            builder.withMember("servers", (ToNode)((ArrayNode)this.getServers().stream().map(Component::toNode).collect(ArrayNode.collect())));
        }
        if (!this.tags.isEmpty()) {
            builder.withMember("tags", (ToNode)((ArrayNode)this.getTags().stream().map(Node::from).collect(ArrayNode.collect())));
        }
        return builder;
    }

    public Builder toBuilder() {
        Builder builder = ((Builder)OperationObject.builder().extensions(this.getExtensions())).callbacks(this.callbacks).responses(this.responses).parameters(this.parameters).servers(this.servers).summary(this.summary).tags(this.tags).deprecated(this.deprecated).description(this.description).externalDocs(this.externalDocs).operationId(this.operationId).requestBody(this.requestBody);
        this.getSecurity().ifPresent(builder::security);
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder, OperationObject> {
        private final BuilderRef<List<String>> tags = BuilderRef.forList();
        private final BuilderRef<List<ParameterObject>> parameters = BuilderRef.forList();
        private final BuilderRef<Map<String, ResponseObject>> responses = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, CallbackObject>> callbacks = BuilderRef.forSortedMap();
        private final BuilderRef<Set<Map<String, List<String>>>> security = BuilderRef.forOrderedSet();
        private final BuilderRef<List<ServerObject>> servers = BuilderRef.forList();
        private String summary;
        private String description;
        private ExternalDocumentation externalDocs;
        private String operationId;
        private RequestBodyObject requestBody;
        private boolean deprecated;

        private Builder() {
        }

        public OperationObject build() {
            return new OperationObject(this);
        }

        public Builder tags(Collection<String> tags) {
            this.tags.clear();
            tags.forEach(this::addTag);
            return this;
        }

        public Builder addTag(String tag) {
            ((List)this.tags.get()).add(tag);
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder externalDocs(ExternalDocumentation externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        public Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder parameters(Collection<ParameterObject> parameters) {
            this.parameters.clear();
            parameters.forEach(this::addParameter);
            return this;
        }

        public Builder addParameter(ParameterObject parameter) {
            ((List)this.parameters.get()).add(parameter);
            return this;
        }

        public Builder requestBody(RequestBodyObject requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public Builder responses(Map<String, ResponseObject> responses) {
            this.responses.clear();
            responses.forEach(this::putResponse);
            return this;
        }

        public Builder putResponse(String statusCode, ResponseObject response) {
            ((Map)this.responses.get()).put(statusCode, response);
            return this;
        }

        public Builder callbacks(Map<String, CallbackObject> callbacks) {
            this.callbacks.clear();
            callbacks.forEach(this::putCallback);
            return this;
        }

        public Builder putCallback(String expression, CallbackObject callback) {
            ((Map)this.callbacks.get()).put(expression, callback);
            return this;
        }

        public Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder security(Collection<Map<String, List<String>>> security) {
            ((Set)this.security.get()).addAll(security);
            return this;
        }

        public Builder addSecurity(Map<String, List<String>> security) {
            ((Set)this.security.get()).add(security);
            return this;
        }

        public Builder servers(Collection<ServerObject> servers) {
            this.servers.clear();
            servers.forEach(this::addServer);
            return this;
        }

        public Builder addServer(ServerObject server) {
            ((List)this.servers.get()).add(server);
            return this;
        }
    }
}

