/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.MediaTypeObject;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class RequestBodyObject
extends Component
implements ToSmithyBuilder<RequestBodyObject> {
    private final String description;
    private final Map<String, MediaTypeObject> content;
    private final boolean required;

    private RequestBodyObject(Builder builder) {
        super(builder);
        this.description = builder.description;
        this.content = new TreeMap<String, MediaTypeObject>((Map)builder.content.peek());
        this.required = builder.required;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Map<String, MediaTypeObject> getContent() {
        return this.content;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("description", this.getDescription().map(Node::from)).withMember("content", (ToNode)((ObjectNode)this.content.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        if (this.required) {
            builder.withMember("required", (ToNode)Node.from((boolean)true));
        }
        return builder;
    }

    public Builder toBuilder() {
        return ((Builder)RequestBodyObject.builder().extensions(this.getExtensions())).description(this.description).content(this.content).required(this.required);
    }

    public static final class Builder
    extends Component.Builder<Builder, RequestBodyObject> {
        private final BuilderRef<Map<String, MediaTypeObject>> content = BuilderRef.forSortedMap();
        private String description;
        private boolean required;

        private Builder() {
        }

        public RequestBodyObject build() {
            return new RequestBodyObject(this);
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder content(Map<String, MediaTypeObject> content) {
            this.content.clear();
            content.forEach(this::putContent);
            return this;
        }

        public Builder putContent(String name, MediaTypeObject content) {
            ((Map)this.content.get()).put(name, content);
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }
    }
}

