/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.EncodingObject;
import software.amazon.smithy.openapi.model.ExampleObject;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MediaTypeObject
extends Component
implements ToSmithyBuilder<MediaTypeObject> {
    private final Schema schema;
    private final ExampleObject example;
    private final Map<String, ExampleObject> examples;
    private final Map<String, EncodingObject> encoding;

    private MediaTypeObject(Builder builder) {
        super(builder);
        this.schema = builder.schema;
        this.example = builder.example;
        this.examples = new TreeMap<String, ExampleObject>((Map)builder.examples.peek());
        this.encoding = new TreeMap<String, EncodingObject>((Map)builder.encoding.peek());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Schema> getSchema() {
        return Optional.ofNullable(this.schema);
    }

    public Optional<ExampleObject> getExample() {
        return Optional.ofNullable(this.example);
    }

    public Map<String, ExampleObject> getExamples() {
        return this.examples;
    }

    public Map<String, EncodingObject> getEncoding() {
        return this.encoding;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("schema", this.getSchema()).withOptionalMember("example", this.getExample());
        if (!this.examples.isEmpty()) {
            builder.withMember("examples", (ToNode)((ObjectNode)this.examples.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.encoding.isEmpty()) {
            builder.withMember("encoding", (ToNode)((ObjectNode)this.encoding.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        return builder;
    }

    public Builder toBuilder() {
        Builder builder = ((Builder)MediaTypeObject.builder().extensions(this.getExtensions())).schema(this.schema).example(this.example == null ? null : this.example.toNode()).encoding(this.encoding);
        for (Map.Entry<String, ExampleObject> ex : this.examples.entrySet()) {
            builder.putExample(ex.getKey(), ex.getValue());
        }
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder, MediaTypeObject> {
        private Schema schema;
        private ExampleObject example;
        private final BuilderRef<Map<String, ExampleObject>> examples = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, EncodingObject>> encoding = BuilderRef.forSortedMap();

        private Builder() {
        }

        public MediaTypeObject build() {
            return new MediaTypeObject(this);
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder example(Node example) {
            this.example = ExampleObject.fromNode(example);
            return this;
        }

        public Builder examples(Map<String, Node> examples) {
            this.examples.clear();
            for (Map.Entry<String, Node> example : examples.entrySet()) {
                ((Map)this.examples.get()).put(example.getKey(), ExampleObject.fromNode(example.getValue()));
            }
            return this;
        }

        public Builder putExample(String name, ExampleObject example) {
            ((Map)this.examples.get()).put(name, example);
            return this;
        }

        public Builder encoding(Map<String, EncodingObject> encoding) {
            this.encoding.clear();
            encoding.forEach(this::putEncoding);
            return this;
        }

        public Builder putEncoding(String name, EncodingObject encodingObject) {
            ((Map)this.encoding.get()).put(name, encodingObject);
            return this;
        }
    }
}

