/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.protocols;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.protocols.RestJson1Trait;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.protocols.AbstractRestProtocol;

public final class AwsRestJson1Protocol
extends AbstractRestProtocol<RestJson1Trait> {
    @Override
    public Class<RestJson1Trait> getProtocolType() {
        return RestJson1Trait.class;
    }

    @Override
    public void updateDefaultSettings(Model model, OpenApiConfig config) {
        config.setUseJsonName(true);
        config.setDefaultTimestampFormat(TimestampFormatTrait.Format.EPOCH_SECONDS);
    }

    @Override
    String getDocumentMediaType(Context context, Shape operationOrError, AbstractRestProtocol.MessageType message) {
        return context.getConfig().getJsonContentType();
    }

    @Override
    Schema createDocumentSchema(Context<RestJson1Trait> context, Shape operationOrError, List<HttpBinding> bindings, AbstractRestProtocol.MessageType message) {
        if (bindings.isEmpty()) {
            return Schema.builder().type("object").build();
        }
        ShapeId container = bindings.get(0).getMember().getContainer();
        StructureShape containerShape = (StructureShape)context.getModel().expectShape(container, StructureShape.class);
        Set documentMemberNames = bindings.stream().map(HttpBinding::getMemberName).collect(Collectors.toSet());
        StructureShape.Builder containerShapeBuilder = containerShape.toBuilder();
        for (String memberName : containerShape.getAllMembers().keySet()) {
            if (documentMemberNames.contains(memberName)) continue;
            containerShapeBuilder.removeMember(memberName);
        }
        StructureShape cleanedShape = containerShapeBuilder.build();
        return context.getJsonSchemaConverter().convertShape((Shape)cleanedShape).getRootSchema();
    }
}

