/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SecurityScheme
extends Component
implements ToSmithyBuilder<SecurityScheme> {
    private final String type;
    private final String description;
    private final String name;
    private final String in;
    private final String scheme;
    private final String bearerFormat;
    private final String openIdConnectUrl;
    private final ObjectNode flows;

    private SecurityScheme(Builder builder) {
        super(builder);
        this.type = (String)SmithyBuilder.requiredState((String)"type", (Object)builder.type);
        this.description = builder.description;
        this.name = builder.name;
        this.in = builder.in;
        this.scheme = builder.scheme;
        this.bearerFormat = builder.bearerFormat;
        this.openIdConnectUrl = builder.openIdConnectUrl;
        this.flows = builder.flows;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getIn() {
        return Optional.ofNullable(this.in);
    }

    public Optional<String> getScheme() {
        return Optional.ofNullable(this.scheme);
    }

    public Optional<String> getBearerFormat() {
        return Optional.ofNullable(this.bearerFormat);
    }

    public Optional<String> getOpenIdConnectUrl() {
        return Optional.ofNullable(this.openIdConnectUrl);
    }

    public Optional<ObjectNode> getFlows() {
        return Optional.ofNullable(this.flows);
    }

    public Builder toBuilder() {
        return ((Builder)SecurityScheme.builder().extensions(this.getExtensions())).type(this.type).description(this.description).name(this.name).in(this.in).scheme(this.scheme).bearerFormat(this.bearerFormat).openIdConnectUrl(this.openIdConnectUrl).flows(this.flows);
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        return Node.objectNodeBuilder().withMember("type", this.type).withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("name", this.getName().map(Node::from)).withOptionalMember("in", this.getIn().map(Node::from)).withOptionalMember("scheme", this.getScheme().map(Node::from)).withOptionalMember("bearerFormat", this.getBearerFormat().map(Node::from)).withOptionalMember("openIdConnectUrl", this.getOpenIdConnectUrl().map(Node::from)).withOptionalMember("flows", this.getFlows());
    }

    public static final class Builder
    extends Component.Builder<Builder, SecurityScheme> {
        private String type;
        private String description;
        private String name;
        private String in;
        private String scheme;
        private String bearerFormat;
        private String openIdConnectUrl;
        private ObjectNode flows;

        public SecurityScheme build() {
            return new SecurityScheme(this);
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder in(String in) {
            this.in = in;
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder bearerFormat(String bearerFormat) {
            this.bearerFormat = bearerFormat;
            return this;
        }

        public Builder openIdConnectUrl(String openIdConnectUrl) {
            this.openIdConnectUrl = openIdConnectUrl;
            return this;
        }

        public Builder flows(ObjectNode flows) {
            this.flows = flows;
            return this;
        }
    }
}

