/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.protocols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.EventStreamIndex;
import software.amazon.smithy.model.knowledge.EventStreamInfo;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiProtocol;
import software.amazon.smithy.openapi.fromsmithy.protocols.HeaderSchemaVisitor;
import software.amazon.smithy.openapi.fromsmithy.protocols.ModelUtils;
import software.amazon.smithy.openapi.fromsmithy.protocols.QuerySchemaVisitor;
import software.amazon.smithy.openapi.model.MediaTypeObject;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.Ref;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;

abstract class AbstractRestProtocol<T extends Trait>
implements OpenApiProtocol<T> {
    private static final String AWS_EVENT_STREAM_CONTENT_TYPE = "application/vnd.amazon.eventstream";
    private static final Pattern NON_ALPHA_NUMERIC = Pattern.compile("[^A-Za-z0-9]");
    private static final Logger LOGGER = Logger.getLogger(AbstractRestProtocol.class.getName());

    AbstractRestProtocol() {
    }

    abstract String getDocumentMediaType(Context<T> var1, Shape var2, MessageType var3);

    abstract Schema createDocumentSchema(Context<T> var1, Shape var2, List<HttpBinding> var3, MessageType var4);

    @Override
    public Optional<OpenApiProtocol.Operation> createOperation(Context<T> context, OperationShape operation) {
        ServiceShape serviceShape = context.getService();
        return operation.getTrait(HttpTrait.class).map(httpTrait -> {
            HttpBindingIndex bindingIndex = HttpBindingIndex.of((Model)context.getModel());
            EventStreamIndex eventStreamIndex = EventStreamIndex.of((Model)context.getModel());
            String method = context.getOpenApiProtocol().getOperationMethod(context, operation);
            String uri = context.getOpenApiProtocol().getOperationUri(context, operation);
            OperationObject.Builder builder = OperationObject.builder().operationId(serviceShape.getContextualName((ToShapeId)operation));
            this.createPathParameters(context, operation).forEach(builder::addParameter);
            this.createQueryParameters(context, operation).forEach(builder::addParameter);
            this.createRequestHeaderParameters(context, operation).forEach(builder::addParameter);
            this.createRequestBody(context, bindingIndex, eventStreamIndex, operation).ifPresent(builder::requestBody);
            this.createResponses(context, bindingIndex, eventStreamIndex, operation).forEach(builder::putResponse);
            return OpenApiProtocol.Operation.create(method, uri, builder);
        });
    }

    private List<ParameterObject> createPathParameters(Context<T> context, OperationShape operation) {
        ArrayList<ParameterObject> result = new ArrayList<ParameterObject>();
        HttpBindingIndex bindingIndex = HttpBindingIndex.of((Model)context.getModel());
        HttpTrait httpTrait = (HttpTrait)operation.expectTrait(HttpTrait.class);
        for (HttpBinding binding : bindingIndex.getRequestBindings((ToShapeId)operation, HttpBinding.Location.LABEL)) {
            Schema schema = this.createPathParameterSchema(context, binding);
            String memberName = binding.getMemberName();
            SmithyPattern.Segment label = (SmithyPattern.Segment)httpTrait.getUri().getLabel(memberName).orElseThrow(() -> new OpenApiException(String.format("Unable to find URI label on %s for %s: %s", operation.getId(), binding.getMemberName(), httpTrait.getUri())));
            String name = label.getContent();
            if (label.isGreedyLabel() && !context.getConfig().getRemoveGreedyParameterSuffix()) {
                name = name + "+";
            }
            result.add(ModelUtils.createParameterMember(context, binding.getMember()).name(name).in("path").schema(schema).build());
        }
        return result;
    }

    private Schema createPathParameterSchema(Context<T> context, HttpBinding binding) {
        MemberShape member = binding.getMember();
        if (this.needsInlineTimestampSchema(context, member)) {
            Schema.Builder copiedBuilder = ModelUtils.convertSchemaToStringBuilder(context.getSchema(context.getPointer((ToShapeId)member)));
            return copiedBuilder.format("date-time").build();
        }
        if (context.getJsonSchemaConverter().isInlined((Shape)member)) {
            return context.getJsonSchemaConverter().convertShape((Shape)member).getRootSchema();
        }
        return context.createRef((ToShapeId)binding.getMember());
    }

    private boolean needsInlineTimestampSchema(Context<? extends Trait> context, MemberShape member) {
        if (member.getMemberTrait(context.getModel(), TimestampFormatTrait.class).isPresent()) {
            return false;
        }
        return context.getModel().getShape(member.getTarget()).filter(Shape::isTimestampShape).isPresent();
    }

    private List<ParameterObject> createQueryParameters(Context<T> context, OperationShape operation) {
        HttpBindingIndex httpBindingIndex = HttpBindingIndex.of((Model)context.getModel());
        ArrayList<ParameterObject> result = new ArrayList<ParameterObject>();
        ArrayList bindings = new ArrayList();
        bindings.addAll(httpBindingIndex.getRequestBindings((ToShapeId)operation, HttpBinding.Location.QUERY));
        bindings.addAll(httpBindingIndex.getRequestBindings((ToShapeId)operation, HttpBinding.Location.QUERY_PARAMS));
        for (HttpBinding binding : bindings) {
            MemberShape member = binding.getMember();
            ParameterObject.Builder param = ModelUtils.createParameterMember(context, member).in("query").name(binding.getLocationName());
            Shape target = context.getModel().expectShape(member.getTarget());
            if (target instanceof CollectionShape) {
                param.style("form").explode(true);
            }
            if (binding.getLocation().equals((Object)HttpBinding.Location.QUERY_PARAMS)) {
                param.style("form");
                Shape shape = context.getModel().expectShape(((MapShape)target.asMapShape().get()).getValue().getTarget());
                if (shape instanceof CollectionShape) {
                    param.explode(true);
                }
            }
            param.schema(this.createQuerySchema(context, member, target));
            result.add(param.build());
        }
        return result;
    }

    private Schema createQuerySchema(Context<T> context, MemberShape member, Shape target) {
        Schema refSchema = context.inlineOrReferenceSchema(member);
        QuerySchemaVisitor<T> visitor = new QuerySchemaVisitor<T>(context, refSchema, member);
        return (Schema)target.accept(visitor);
    }

    private Collection<ParameterObject> createRequestHeaderParameters(Context<T> context, OperationShape operation) {
        List bindings = HttpBindingIndex.of((Model)context.getModel()).getRequestBindings((ToShapeId)operation, HttpBinding.Location.HEADER);
        return this.createHeaderParameters(context, bindings, MessageType.REQUEST).values();
    }

    private Map<String, ParameterObject> createHeaderParameters(Context<T> context, List<HttpBinding> bindings, MessageType messageType) {
        TreeMap<String, ParameterObject> result = new TreeMap<String, ParameterObject>();
        for (HttpBinding binding : bindings) {
            MemberShape member = binding.getMember();
            ParameterObject.Builder param = ModelUtils.createParameterMember(context, member);
            if (messageType == MessageType.REQUEST) {
                param.in("header").name(binding.getLocationName());
            } else {
                param.in(null).name(null);
            }
            Shape target = context.getModel().expectShape(member.getTarget());
            Schema refSchema = context.inlineOrReferenceSchema(member);
            HeaderSchemaVisitor<T> visitor = new HeaderSchemaVisitor<T>(context, refSchema, member);
            param.schema((Schema)target.accept(visitor));
            result.put(binding.getLocationName(), param.build());
        }
        return result;
    }

    private Optional<RequestBodyObject> createRequestBody(Context<T> context, HttpBindingIndex bindingIndex, EventStreamIndex eventStreamIndex, OperationShape operation) {
        List payloadBindings = bindingIndex.getRequestBindings((ToShapeId)operation, HttpBinding.Location.PAYLOAD);
        String documentMediaType = this.getDocumentMediaType(context, (Shape)operation, MessageType.REQUEST);
        String eventStreamMediaType = eventStreamIndex.getInputInfo((ToShapeId)operation).map(info -> this.getEventStreamMediaType(context, (EventStreamInfo)info)).orElse(null);
        String mediaType = bindingIndex.determineRequestContentType((ToShapeId)operation, documentMediaType, eventStreamMediaType).orElse(null);
        return payloadBindings.isEmpty() ? this.createRequestDocument(mediaType, context, bindingIndex, operation) : this.createRequestPayload(mediaType, context, (HttpBinding)payloadBindings.get(0), operation);
    }

    protected String getEventStreamMediaType(Context<T> context, EventStreamInfo info) {
        return AWS_EVENT_STREAM_CONTENT_TYPE;
    }

    private Optional<RequestBodyObject> createRequestPayload(String mediaTypeRange, Context<T> context, HttpBinding binding, OperationShape operation) {
        Schema schema = context.inlineOrReferenceSchema(binding.getMember());
        MediaTypeObject mediaTypeObject = this.getMediaTypeObject(context, schema, (Shape)operation, shape -> {
            String shapeName = context.getService().getContextualName((ToShapeId)shape.getId());
            return shapeName + "InputPayload";
        });
        RequestBodyObject requestBodyObject = RequestBodyObject.builder().putContent(Objects.requireNonNull(mediaTypeRange), mediaTypeObject).required(binding.getMember().isRequired()).build();
        return Optional.of(requestBodyObject);
    }

    private Optional<RequestBodyObject> createRequestDocument(String mediaType, Context<T> context, HttpBindingIndex bindingIndex, OperationShape operation) {
        List bindings = bindingIndex.getRequestBindings((ToShapeId)operation, HttpBinding.Location.DOCUMENT);
        if (bindings.isEmpty()) {
            return Optional.empty();
        }
        Schema schema = this.createDocumentSchema(context, (Shape)operation, bindings, MessageType.REQUEST);
        String contextName = context.getService().getContextualName((ToShapeId)operation);
        String synthesizedName = this.stripNonAlphaNumericCharsIfNecessary(context, contextName) + "RequestContent";
        String pointer = context.putSynthesizedSchema(synthesizedName, schema);
        MediaTypeObject mediaTypeObject = MediaTypeObject.builder().schema(Schema.builder().ref(pointer).build()).build();
        boolean required = false;
        for (HttpBinding binding : bindings) {
            if (!binding.getMember().isRequired()) continue;
            required = true;
            break;
        }
        return Optional.of(RequestBodyObject.builder().putContent(mediaType, mediaTypeObject).required(required).build());
    }

    private Map<String, ResponseObject> createResponses(Context<T> context, HttpBindingIndex bindingIndex, EventStreamIndex eventStreamIndex, OperationShape operation) {
        TreeMap<String, ResponseObject> result = new TreeMap<String, ResponseObject>();
        OperationIndex operationIndex = OperationIndex.of((Model)context.getModel());
        operationIndex.getOutput((ToShapeId)operation).ifPresent(output -> this.updateResponsesMapWithResponseStatusAndObject(context, bindingIndex, eventStreamIndex, operation, (StructureShape)output, (Map<String, ResponseObject>)result));
        for (StructureShape error : operationIndex.getErrors((ToShapeId)operation)) {
            this.updateResponsesMapWithResponseStatusAndObject(context, bindingIndex, eventStreamIndex, operation, error, result);
        }
        return result;
    }

    private void updateResponsesMapWithResponseStatusAndObject(Context<T> context, HttpBindingIndex bindingIndex, EventStreamIndex eventStreamIndex, OperationShape operation, StructureShape shape, Map<String, ResponseObject> responses) {
        StructureShape operationOrError = shape.hasTrait(ErrorTrait.class) ? shape : operation;
        String statusCode = context.getOpenApiProtocol().getOperationResponseStatusCode(context, (ToShapeId)operationOrError);
        ResponseObject response = this.createResponse(context, bindingIndex, eventStreamIndex, statusCode, (Shape)operationOrError);
        responses.put(statusCode, response);
    }

    private ResponseObject createResponse(Context<T> context, HttpBindingIndex bindingIndex, EventStreamIndex eventStreamIndex, String statusCode, Shape operationOrError) {
        ResponseObject.Builder responseBuilder = ResponseObject.builder();
        String contextName = context.getService().getContextualName((ToShapeId)operationOrError);
        String responseName = this.stripNonAlphaNumericCharsIfNecessary(context, contextName);
        responseBuilder.description(String.format("%s %s response", responseName, statusCode));
        this.createResponseHeaderParameters(context, operationOrError).forEach((k, v) -> responseBuilder.putHeader((String)k, Ref.local(v)));
        this.addResponseContent(context, bindingIndex, eventStreamIndex, responseBuilder, operationOrError);
        return responseBuilder.build();
    }

    private Map<String, ParameterObject> createResponseHeaderParameters(Context<T> context, Shape operationOrError) {
        List bindings = HttpBindingIndex.of((Model)context.getModel()).getResponseBindings((ToShapeId)operationOrError, HttpBinding.Location.HEADER);
        return this.createHeaderParameters(context, bindings, MessageType.RESPONSE);
    }

    private void addResponseContent(Context<T> context, HttpBindingIndex bindingIndex, EventStreamIndex eventStreamIndex, ResponseObject.Builder responseBuilder, Shape operationOrError) {
        List payloadBindings = bindingIndex.getResponseBindings((ToShapeId)operationOrError, HttpBinding.Location.PAYLOAD);
        String documentMediaType = this.getDocumentMediaType(context, operationOrError, MessageType.RESPONSE);
        String eventStreamMediaType = eventStreamIndex.getOutputInfo((ToShapeId)operationOrError).map(info -> this.getEventStreamMediaType(context, (EventStreamInfo)info)).orElse(null);
        String mediaType = bindingIndex.determineResponseContentType((ToShapeId)operationOrError, documentMediaType, eventStreamMediaType).orElse(null);
        if (!payloadBindings.isEmpty()) {
            this.createResponsePayload(mediaType, context, (HttpBinding)payloadBindings.get(0), responseBuilder, operationOrError);
        } else {
            this.createResponseDocumentIfNeeded(mediaType, context, bindingIndex, responseBuilder, operationOrError);
        }
    }

    private void createResponsePayload(String mediaType, Context<T> context, HttpBinding binding, ResponseObject.Builder responseBuilder, Shape operationOrError) {
        Objects.requireNonNull(mediaType, "Unable to determine response media type for " + operationOrError);
        Schema schema = context.inlineOrReferenceSchema(binding.getMember());
        MediaTypeObject mediaTypeObject = this.getMediaTypeObject(context, schema, operationOrError, shape -> {
            String shapeName = context.getService().getContextualName((ToShapeId)shape.getId());
            return shape instanceof OperationShape ? shapeName + "OutputPayload" : shapeName + "ErrorPayload";
        });
        responseBuilder.putContent(mediaType, mediaTypeObject);
    }

    private MediaTypeObject getMediaTypeObject(Context<T> context, Schema schema, Shape shape, Function<Shape, String> createSynthesizedName) {
        if (!schema.getType().isPresent() && schema.getRef().isPresent()) {
            return MediaTypeObject.builder().schema(Schema.builder().ref((String)schema.getRef().get()).build()).build();
        }
        String synthesizedName = createSynthesizedName.apply(shape);
        String pointer = context.putSynthesizedSchema(synthesizedName, schema);
        return MediaTypeObject.builder().schema(Schema.builder().ref(pointer).build()).build();
    }

    private void createResponseDocumentIfNeeded(String mediaType, Context<T> context, HttpBindingIndex bindingIndex, ResponseObject.Builder responseBuilder, Shape operationOrError) {
        List bindings = bindingIndex.getResponseBindings((ToShapeId)operationOrError, HttpBinding.Location.DOCUMENT);
        if (bindings.isEmpty()) {
            return;
        }
        MessageType messageType = operationOrError instanceof OperationShape ? MessageType.RESPONSE : MessageType.ERROR;
        Schema schema = this.createDocumentSchema(context, operationOrError, bindings, messageType);
        String contextName = context.getService().getContextualName((ToShapeId)operationOrError);
        String synthesizedName = this.stripNonAlphaNumericCharsIfNecessary(context, contextName) + "ResponseContent";
        String pointer = context.putSynthesizedSchema(synthesizedName, schema);
        MediaTypeObject mediaTypeObject = MediaTypeObject.builder().schema(Schema.builder().ref(pointer).build()).build();
        responseBuilder.putContent(mediaType, mediaTypeObject);
    }

    private String stripNonAlphaNumericCharsIfNecessary(Context<T> context, String name) {
        String alphanumericOnly = NON_ALPHA_NUMERIC.matcher(name).replaceAll("");
        if (context.getConfig().getAlphanumericOnlyRefs() && !alphanumericOnly.equals(name)) {
            LOGGER.info(() -> String.format("Removing non-alphanumeric characters from %s to assure compatibility with vendors that only allow alphanumeric shape names.", name));
            return alphanumericOnly;
        }
        return name;
    }

    static enum MessageType {
        REQUEST,
        RESPONSE,
        ERROR;

    }
}

