/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.utils.SetUtils;

public interface OpenApiProtocol<T extends Trait> {
    public Class<T> getProtocolType();

    default public void updateDefaultSettings(Model model, OpenApiConfig config) {
    }

    public Optional<Operation> createOperation(Context<T> var1, OperationShape var2);

    default public String getOperationUri(Context<T> context, OperationShape operation) {
        return operation.getTrait(HttpTrait.class).map(HttpTrait::getUri).map(SmithyPattern::toString).orElseThrow(() -> new OpenApiException("The `" + operation.getId() + "` operation has no `http` binding trait, which is required to compute a URI (using the default protocol implementation)"));
    }

    default public String getOperationMethod(Context<T> context, OperationShape operation) {
        return operation.getTrait(HttpTrait.class).map(HttpTrait::getMethod).orElseThrow(() -> new OpenApiException("The `" + operation.getId() + "` operation has no `http` binding trait, which is required to compute a method (using the default protocol implementation)"));
    }

    default public String getOperationResponseStatusCode(Context<T> context, ToShapeId operationOrError) {
        return String.valueOf(((HttpBindingIndex)context.getModel().getKnowledge(HttpBindingIndex.class)).getResponseCode(operationOrError));
    }

    default public Set<String> getProtocolRequestHeaders(Context<T> context, OperationShape operationShape) {
        return SetUtils.of();
    }

    default public Set<String> getProtocolResponseHeaders(Context<T> context, OperationShape operationShape) {
        return SetUtils.of();
    }

    public static final class Operation {
        private final String method;
        private final String uri;
        private final OperationObject.Builder operation;

        private Operation(String method, String uri, OperationObject.Builder operation) {
            this.method = method;
            this.uri = uri;
            this.operation = operation;
        }

        public static Operation create(String method, String uri, OperationObject.Builder operation) {
            return new Operation(method, uri, operation);
        }

        public String getMethod() {
            return this.method;
        }

        public String getUri() {
            return this.uri;
        }

        public OperationObject.Builder getOperation() {
            return this.operation;
        }
    }
}

