/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.mappers;

import java.util.Map;
import java.util.logging.Logger;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodePointer;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class OpenApiJsonAdd
implements OpenApiMapper {
    private static final Logger LOGGER = Logger.getLogger(OpenApiJsonAdd.class.getName());

    @Override
    public byte getOrder() {
        return 122;
    }

    @Override
    public ObjectNode updateNode(Context<? extends Trait> context, OpenApi openapi, ObjectNode node) {
        Map<String, Node> add = context.getConfig().getJsonAdd();
        if (add.isEmpty()) {
            return node;
        }
        ObjectNode result = node;
        for (Map.Entry<String, Node> entry : add.entrySet()) {
            try {
                LOGGER.info(() -> "OpenAPI `jsonAdd`: adding `" + (String)entry.getKey() + "`");
                result = NodePointer.parse((String)entry.getKey()).addWithIntermediateValues((Node)result, entry.getValue().toNode()).expectObjectNode();
            }
            catch (IllegalArgumentException e) {
                throw new OpenApiException(e.getMessage(), e);
            }
        }
        return result;
    }
}

