/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.PathItem;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.openapi.model.SecurityScheme;

public interface OpenApiMapper {
    default public byte getOrder() {
        return 0;
    }

    default public OperationObject updateOperation(Context context, OperationShape shape, OperationObject operation) {
        return operation;
    }

    default public PathItem updatePathItem(Context context, String path, PathItem pathItem) {
        return pathItem;
    }

    default public ParameterObject updateParameter(Context context, OperationShape operation, ParameterObject parameterObject) {
        return parameterObject;
    }

    default public RequestBodyObject updateRequestBody(Context context, OperationShape shape, RequestBodyObject requestBody) {
        return requestBody;
    }

    default public ResponseObject updateResponse(Context context, String status, OperationShape shape, ResponseObject response) {
        return response;
    }

    default public void before(Context context, OpenApi.Builder builder) {
    }

    default public SecurityScheme updateSecurityScheme(Context context, String authName, SecurityScheme securityScheme) {
        return securityScheme;
    }

    default public Map<String, List<String>> updateSecurity(Context context, Shape shape, SecuritySchemeConverter converter, Map<String, List<String>> requirement) {
        return requirement;
    }

    default public OpenApi after(Context context, OpenApi openapi) {
        return openapi;
    }

    default public ObjectNode updateNode(Context context, OpenApi openapi, ObjectNode node) {
        return node;
    }

    public static OpenApiMapper compose(List<OpenApiMapper> mappers) {
        final ArrayList<OpenApiMapper> sorted = new ArrayList<OpenApiMapper>(mappers);
        sorted.sort(Comparator.comparingInt(OpenApiMapper::getOrder));
        return new OpenApiMapper(){

            @Override
            public OperationObject updateOperation(Context context, OperationShape shape, OperationObject operation) {
                for (OpenApiMapper plugin : sorted) {
                    if (operation == null) {
                        return null;
                    }
                    operation = plugin.updateOperation(context, shape, operation);
                }
                return operation;
            }

            @Override
            public PathItem updatePathItem(Context context, String path, PathItem pathItem) {
                for (OpenApiMapper plugin : sorted) {
                    if (pathItem == null) {
                        return null;
                    }
                    pathItem = plugin.updatePathItem(context, path, pathItem);
                }
                return pathItem;
            }

            @Override
            public ParameterObject updateParameter(Context context, OperationShape operation, ParameterObject parameterObject) {
                for (OpenApiMapper plugin : sorted) {
                    if (parameterObject == null) {
                        return null;
                    }
                    parameterObject = plugin.updateParameter(context, operation, parameterObject);
                }
                return parameterObject;
            }

            @Override
            public RequestBodyObject updateRequestBody(Context context, OperationShape shape, RequestBodyObject requestBody) {
                for (OpenApiMapper plugin : sorted) {
                    if (requestBody == null) {
                        return null;
                    }
                    requestBody = plugin.updateRequestBody(context, shape, requestBody);
                }
                return requestBody;
            }

            @Override
            public ResponseObject updateResponse(Context context, String status, OperationShape shape, ResponseObject response) {
                for (OpenApiMapper plugin : sorted) {
                    if (response == null) {
                        return null;
                    }
                    response = plugin.updateResponse(context, status, shape, response);
                }
                return response;
            }

            @Override
            public SecurityScheme updateSecurityScheme(Context context, String name, SecurityScheme securityScheme) {
                for (OpenApiMapper plugin : sorted) {
                    if (securityScheme == null) {
                        return null;
                    }
                    securityScheme = plugin.updateSecurityScheme(context, name, securityScheme);
                }
                return securityScheme;
            }

            @Override
            public Map<String, List<String>> updateSecurity(Context context, Shape shape, SecuritySchemeConverter converter, Map<String, List<String>> requirement) {
                for (OpenApiMapper plugin : sorted) {
                    if (requirement == null || requirement.isEmpty()) {
                        return null;
                    }
                    requirement = plugin.updateSecurity(context, shape, converter, requirement);
                }
                return requirement;
            }

            @Override
            public void before(Context context, OpenApi.Builder builder) {
                for (OpenApiMapper plugin : sorted) {
                    plugin.before(context, builder);
                }
            }

            @Override
            public OpenApi after(Context context, OpenApi openapi) {
                for (OpenApiMapper plugin : sorted) {
                    openapi = plugin.after(context, openapi);
                }
                return openapi;
            }

            @Override
            public ObjectNode updateNode(Context context, OpenApi openapi, ObjectNode node) {
                for (OpenApiMapper plugin : sorted) {
                    node = plugin.updateNode(context, openapi, node);
                }
                return node;
            }
        };
    }
}

