/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.utils.ListUtils;

final class NeighborVisitor
extends ShapeVisitor.Default<List<Relationship>>
implements NeighborProvider {
    private final Model model;

    NeighborVisitor(Model model) {
        this.model = model;
    }

    @Override
    public List<Relationship> getNeighbors(Shape shape) {
        return shape.accept(this);
    }

    @Override
    public List<Relationship> getDefault(Shape shape) {
        return ListUtils.of();
    }

    @Override
    public List<Relationship> serviceShape(ServiceShape shape) {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (ShapeId operation : shape.getOperations()) {
            this.addBinding(result, shape, operation, RelationshipType.OPERATION);
        }
        for (ShapeId resource : shape.getResources()) {
            this.addBinding(result, shape, resource, RelationshipType.RESOURCE);
        }
        return result;
    }

    private void addBinding(List<Relationship> result, Shape container, ShapeId bindingTarget, RelationshipType type) {
        result.add(this.relationship(container, type, bindingTarget));
        this.addBound(result, container, bindingTarget);
    }

    private void addBound(List<Relationship> result, Shape container, ShapeId bindingTarget) {
        this.model.getShape(bindingTarget).ifPresent(op -> result.add(this.relationship((Shape)op, RelationshipType.BOUND, container.getId())));
    }

    @Override
    public List<Relationship> resourceShape(ResourceShape shape) {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        shape.getIdentifiers().forEach((k, v) -> result.add(this.relationship((Shape)shape, RelationshipType.IDENTIFIER, (ShapeId)v)));
        shape.getResources().forEach(id -> this.addBinding((List<Relationship>)result, shape, (ShapeId)id, RelationshipType.RESOURCE));
        shape.getAllOperations().forEach(id -> this.addBinding((List<Relationship>)result, shape, (ShapeId)id, RelationshipType.OPERATION));
        shape.getRead().ifPresent(id -> {
            result.add(this.relationship((Shape)shape, RelationshipType.READ, (ShapeId)id));
            result.add(this.relationship((Shape)shape, RelationshipType.INSTANCE_OPERATION, (ShapeId)id));
        });
        shape.getUpdate().ifPresent(id -> {
            result.add(this.relationship((Shape)shape, RelationshipType.UPDATE, (ShapeId)id));
            result.add(this.relationship((Shape)shape, RelationshipType.INSTANCE_OPERATION, (ShapeId)id));
        });
        shape.getDelete().ifPresent(id -> {
            result.add(this.relationship((Shape)shape, RelationshipType.DELETE, (ShapeId)id));
            result.add(this.relationship((Shape)shape, RelationshipType.INSTANCE_OPERATION, (ShapeId)id));
        });
        shape.getPut().ifPresent(id -> {
            result.add(this.relationship((Shape)shape, RelationshipType.PUT, (ShapeId)id));
            result.add(this.relationship((Shape)shape, RelationshipType.INSTANCE_OPERATION, (ShapeId)id));
        });
        shape.getCreate().ifPresent(id -> {
            result.add(this.relationship((Shape)shape, RelationshipType.CREATE, (ShapeId)id));
            result.add(this.relationship((Shape)shape, RelationshipType.COLLECTION_OPERATION, (ShapeId)id));
        });
        shape.getList().ifPresent(id -> {
            result.add(this.relationship((Shape)shape, RelationshipType.LIST, (ShapeId)id));
            result.add(this.relationship((Shape)shape, RelationshipType.COLLECTION_OPERATION, (ShapeId)id));
        });
        shape.getCollectionOperations().forEach(id -> result.add(this.relationship((Shape)shape, RelationshipType.COLLECTION_OPERATION, (ShapeId)id)));
        shape.getOperations().forEach(id -> result.add(this.relationship((Shape)shape, RelationshipType.INSTANCE_OPERATION, (ShapeId)id)));
        for (ResourceShape resource : this.model.getResourceShapes()) {
            this.addServiceAndResourceBindings(result, shape, resource);
        }
        for (ServiceShape service : this.model.getServiceShapes()) {
            this.addServiceAndResourceBindings(result, shape, service);
        }
        return result;
    }

    private void addServiceAndResourceBindings(List<Relationship> result, ResourceShape resource, EntityShape entity) {
        if (entity.getResources().contains(resource.getId())) {
            this.addBinding(result, entity, resource.getId(), RelationshipType.RESOURCE);
        }
    }

    @Override
    public List<Relationship> operationShape(OperationShape shape) {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        shape.getInput().ifPresent(id -> result.add(this.relationship((Shape)shape, RelationshipType.INPUT, (ShapeId)id)));
        shape.getOutput().ifPresent(id -> result.add(this.relationship((Shape)shape, RelationshipType.OUTPUT, (ShapeId)id)));
        for (ShapeId errorId : shape.getErrors()) {
            result.add(this.relationship((Shape)shape, RelationshipType.ERROR, errorId));
        }
        return result;
    }

    @Override
    public List<Relationship> memberShape(MemberShape shape) {
        ArrayList<Relationship> result = new ArrayList<Relationship>(2);
        result.add(this.relationship((Shape)shape, RelationshipType.MEMBER_CONTAINER, shape.getContainer()));
        result.add(this.relationship((Shape)shape, RelationshipType.MEMBER_TARGET, shape.getTarget()));
        return result;
    }

    @Override
    public List<Relationship> listShape(ListShape shape) {
        return ListUtils.of((Object)this.relationship((Shape)shape, RelationshipType.LIST_MEMBER, shape.getMember()));
    }

    @Override
    public List<Relationship> setShape(SetShape shape) {
        return ListUtils.of((Object)this.relationship((Shape)shape, RelationshipType.SET_MEMBER, shape.getMember()));
    }

    @Override
    public List<Relationship> mapShape(MapShape shape) {
        ArrayList<Relationship> result = new ArrayList<Relationship>(2);
        result.add(this.relationship((Shape)shape, RelationshipType.MAP_KEY, shape.getKey()));
        result.add(this.relationship((Shape)shape, RelationshipType.MAP_VALUE, shape.getValue()));
        return result;
    }

    @Override
    public List<Relationship> structureShape(StructureShape shape) {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (MemberShape member : shape.getAllMembers().values()) {
            result.add(Relationship.create(shape, RelationshipType.STRUCTURE_MEMBER, member));
        }
        return result;
    }

    @Override
    public List<Relationship> unionShape(UnionShape shape) {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (MemberShape member : shape.getAllMembers().values()) {
            result.add(Relationship.create(shape, RelationshipType.UNION_MEMBER, member));
        }
        return result;
    }

    private Relationship relationship(Shape shape, RelationshipType type, MemberShape memberShape) {
        return Relationship.create(shape, type, memberShape);
    }

    private Relationship relationship(Shape shape, RelationshipType type, ShapeId neighborShapeId) {
        return this.model.getShape(neighborShapeId).map(target -> Relationship.create(shape, type, target)).orElseGet(() -> Relationship.createInvalid(shape, type, neighborShapeId));
    }
}

