/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class EnumTraitValidator
extends AbstractValidator {
    private static final Pattern RECOMMENDED_NAME_PATTERN = Pattern.compile("^[A-Z]+[A-Z_0-9]*$");

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(EnumTrait.class)) {
            events.addAll(this.validateEnumTrait(shape, shape.expectTrait(EnumTrait.class)));
        }
        return events;
    }

    private List<ValidationEvent> validateEnumTrait(Shape shape, EnumTrait trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        HashSet<String> names = new HashSet<String>();
        HashSet<String> values = new HashSet<String>();
        for (EnumDefinition definition : trait.getValues()) {
            if (values.add(definition.getValue())) continue;
            events.add(this.error(shape, trait, String.format("Duplicate enum trait values found with the same `value` property of '%s'", definition.getValue())));
        }
        for (EnumDefinition definition : trait.getValues()) {
            if (!definition.getName().isPresent()) continue;
            String name = definition.getName().get();
            if (!names.add(name)) {
                events.add(this.error(shape, trait, String.format("Duplicate enum trait values found with the same `name` property of '%s'", name)));
            }
            if (RECOMMENDED_NAME_PATTERN.matcher(name).find()) continue;
            events.add(this.warning(shape, trait, String.format("The name `%s` does not match the recommended enum name format of beginning with an uppercase letter, followed by any number of uppercase letters, numbers, or underscores.", name)));
        }
        if (!names.isEmpty()) {
            for (EnumDefinition definition : trait.getValues()) {
                if (definition.getName().isPresent()) continue;
                events.add(this.error(shape, trait, String.format("`%s` enum value body is missing the `name` property; if any enum trait value contains a `name` property, then all values must contain the `name` property.", definition.getValue())));
            }
        } else {
            ValidationEvent event = this.warning(shape, trait, "Enums should define the `name` property to allow rich types to be generated in code generators.");
            events.add(event.toBuilder().id("EnumNamesPresent").build());
        }
        return events;
    }
}

