/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class RecommendedTrait
extends AbstractTrait
implements ToSmithyBuilder<RecommendedTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#recommended");
    private final String reason;

    private RecommendedTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.reason = builder.reason;
    }

    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withOptionalMember("reason", this.getReason().map(Node::from));
    }

    public Builder toBuilder() {
        return (Builder)RecommendedTrait.builder().reason(this.reason).sourceLocation(this.getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public RecommendedTrait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            String reason = objectNode.getStringMember("reason").map(StringNode::getValue).orElse(null);
            return ((Builder)RecommendedTrait.builder().sourceLocation(value)).reason(reason).build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<RecommendedTrait, Builder> {
        private String reason;

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public RecommendedTrait build() {
            return new RecommendedTrait(this);
        }
    }
}

