/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;
import software.amazon.smithy.model.validation.node.TimestampValidationStrategy;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;

public final class NodeValidationVisitor
implements ShapeVisitor<List<ValidationEvent>> {
    private static final List<NodeValidatorPlugin> BUILTIN = NodeValidatorPlugin.getBuiltins();
    private final Model model;
    private final TimestampValidationStrategy timestampValidationStrategy;
    private String eventId;
    private Node value;
    private ShapeId eventShapeId;
    private String startingContext;
    private NodeValidatorPlugin.Context validationContext;
    private final NullableIndex nullableIndex;

    private NodeValidationVisitor(Builder builder) {
        this.model = (Model)SmithyBuilder.requiredState((String)"model", (Object)builder.model);
        this.nullableIndex = NullableIndex.of(this.model);
        this.validationContext = new NodeValidatorPlugin.Context(this.model, Feature.enumSet(builder.features));
        this.timestampValidationStrategy = builder.timestampValidationStrategy;
        this.setValue((Node)SmithyBuilder.requiredState((String)"value", (Object)builder.value));
        this.setStartingContext(builder.contextText);
        this.setValue(builder.value);
        this.setEventShapeId(builder.eventShapeId);
        this.setEventId(builder.eventId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setValue(Node value) {
        this.value = Objects.requireNonNull(value);
    }

    public void setEventShapeId(ShapeId eventShapeId) {
        this.eventShapeId = eventShapeId;
    }

    public void setStartingContext(String startingContext) {
        this.startingContext = startingContext == null ? "" : startingContext;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId == null ? "Model" : eventId;
    }

    private NodeValidationVisitor traverse(String segment, Node node) {
        Builder builder = NodeValidationVisitor.builder();
        builder.eventShapeId(this.eventShapeId);
        builder.eventId(this.eventId);
        builder.value(node);
        builder.model(this.model);
        builder.startingContext(this.startingContext.isEmpty() ? segment : this.startingContext + "." + segment);
        builder.timestampValidationStrategy(this.timestampValidationStrategy);
        NodeValidationVisitor visitor = new NodeValidationVisitor(builder);
        visitor.validationContext = this.validationContext;
        return visitor;
    }

    @Override
    public List<ValidationEvent> blobShape(BlobShape shape) {
        return this.value.asStringNode().map(stringNode -> {
            if (this.validationContext.hasFeature(Feature.REQUIRE_BASE_64_BLOB_VALUES)) {
                byte[] encodedValue = stringNode.getValue().getBytes(StandardCharsets.UTF_8);
                try {
                    Base64.getDecoder().decode(encodedValue);
                }
                catch (IllegalArgumentException e) {
                    return ListUtils.of((Object)this.event("Blob value must be a valid base64 string", new String[0]));
                }
            }
            return this.applyPlugins(shape);
        }).orElseGet(() -> this.invalidShape(shape, NodeType.STRING));
    }

    @Override
    public List<ValidationEvent> booleanShape(BooleanShape shape) {
        return this.value.isBooleanNode() ? this.applyPlugins(shape) : this.invalidShape(shape, NodeType.BOOLEAN);
    }

    @Override
    public List<ValidationEvent> byteShape(ByteShape shape) {
        return this.validateNaturalNumber(shape, -128L, 127L);
    }

    @Override
    public List<ValidationEvent> shortShape(ShortShape shape) {
        return this.validateNaturalNumber(shape, -32768L, 32767L);
    }

    @Override
    public List<ValidationEvent> integerShape(IntegerShape shape) {
        return this.validateNaturalNumber(shape, (Long)Integer.MIN_VALUE, (Long)Integer.MAX_VALUE);
    }

    @Override
    public List<ValidationEvent> longShape(LongShape shape) {
        return this.validateNaturalNumber(shape, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public List<ValidationEvent> bigIntegerShape(BigIntegerShape shape) {
        return this.validateNaturalNumber(shape, null, null);
    }

    private List<ValidationEvent> validateNaturalNumber(Shape shape, Long min, Long max) {
        return this.value.asNumberNode().map(number -> {
            if (number.isFloatingPointNumber()) {
                return ListUtils.of((Object)this.event(String.format("%s shapes must not have floating point values, but found `%s` provided for `%s`", new Object[]{shape.getType(), number.getValue(), shape.getId()}), new String[0]));
            }
            Long numberValue = number.getValue().longValue();
            if (min != null && numberValue < min) {
                return ListUtils.of((Object)this.event(String.format("%s value must be > %d, but found %d", new Object[]{shape.getType(), min, numberValue}), new String[0]));
            }
            if (max != null && numberValue > max) {
                return ListUtils.of((Object)this.event(String.format("%s value must be < %d, but found %d", new Object[]{shape.getType(), max, numberValue}), new String[0]));
            }
            return this.applyPlugins(shape);
        }).orElseGet(() -> this.invalidShape(shape, NodeType.NUMBER));
    }

    @Override
    public List<ValidationEvent> floatShape(FloatShape shape) {
        return this.value.isNumberNode() || this.value.isStringNode() ? this.applyPlugins(shape) : this.invalidShape(shape, NodeType.NUMBER);
    }

    @Override
    public List<ValidationEvent> documentShape(DocumentShape shape) {
        return Collections.emptyList();
    }

    @Override
    public List<ValidationEvent> doubleShape(DoubleShape shape) {
        return this.value.isNumberNode() || this.value.isStringNode() ? this.applyPlugins(shape) : this.invalidShape(shape, NodeType.NUMBER);
    }

    @Override
    public List<ValidationEvent> bigDecimalShape(BigDecimalShape shape) {
        return this.value.isNumberNode() ? this.applyPlugins(shape) : this.invalidShape(shape, NodeType.NUMBER);
    }

    @Override
    public List<ValidationEvent> stringShape(StringShape shape) {
        return this.value.asStringNode().map(string -> this.applyPlugins(shape)).orElseGet(() -> this.invalidShape(shape, NodeType.STRING));
    }

    @Override
    public List<ValidationEvent> timestampShape(TimestampShape shape) {
        return this.applyPlugins(shape);
    }

    @Override
    public List<ValidationEvent> listShape(ListShape shape) {
        return this.value.asArrayNode().map(array -> {
            MemberShape member = shape.getMember();
            List<ValidationEvent> events = this.applyPlugins(shape);
            for (int i = 0; i < array.getElements().size(); ++i) {
                events.addAll((Collection<ValidationEvent>)member.accept(this.traverse(String.valueOf(i), array.getElements().get(i))));
            }
            return events;
        }).orElseGet(() -> this.invalidShape(shape, NodeType.ARRAY));
    }

    @Override
    public List<ValidationEvent> mapShape(MapShape shape) {
        return this.value.asObjectNode().map(object -> {
            List<ValidationEvent> events = this.applyPlugins(shape);
            for (Map.Entry<StringNode, Node> entry : object.getMembers().entrySet()) {
                String key = entry.getKey().getValue();
                events.addAll((Collection<ValidationEvent>)this.traverse(key + " (map-key)", entry.getKey()).memberShape(shape.getKey()));
                events.addAll((Collection<ValidationEvent>)this.traverse(key, entry.getValue()).memberShape(shape.getValue()));
            }
            return events;
        }).orElseGet(() -> this.invalidShape(shape, NodeType.OBJECT));
    }

    @Override
    public List<ValidationEvent> structureShape(StructureShape shape) {
        return this.value.asObjectNode().map(object -> {
            List<ValidationEvent> events = this.applyPlugins(shape);
            Map<String, MemberShape> members = shape.getAllMembers();
            for (Map.Entry<String, Node> entry : object.getStringMap().entrySet()) {
                String entryKey = entry.getKey();
                Node entryValue = entry.getValue();
                if (!members.containsKey(entryKey)) {
                    events.add(this.unknownMember(entryKey, shape, Severity.WARNING));
                    continue;
                }
                events.addAll((Collection<ValidationEvent>)this.traverse(entryKey, entryValue).memberShape(members.get(entryKey)));
            }
            for (MemberShape member : members.values()) {
                if (!member.isRequired() || object.getMember(member.getMemberName()).isPresent()) continue;
                Severity severity = this.validationContext.hasFeature(Feature.ALLOW_CONSTRAINT_ERRORS) ? Severity.WARNING : Severity.ERROR;
                events.add(this.event(String.format("Missing required structure member `%s` for `%s`", member.getMemberName(), shape.getId()), severity, new String[0]));
            }
            return events;
        }).orElseGet(() -> this.invalidShape(shape, NodeType.OBJECT));
    }

    @Override
    public List<ValidationEvent> unionShape(UnionShape shape) {
        return this.value.asObjectNode().map(object -> {
            List<ValidationEvent> events = this.applyPlugins(shape);
            if (object.size() > 1) {
                events.add(this.event("union values can contain a value for only a single member", new String[0]));
            } else {
                Map<String, MemberShape> members = shape.getAllMembers();
                for (Map.Entry<String, Node> entry : object.getStringMap().entrySet()) {
                    String entryKey = entry.getKey();
                    Node entryValue = entry.getValue();
                    if (!members.containsKey(entryKey)) {
                        events.add(this.unknownMember(entryKey, shape, Severity.ERROR));
                        continue;
                    }
                    events.addAll((Collection<ValidationEvent>)this.traverse(entryKey, entryValue).memberShape(members.get(entryKey)));
                }
            }
            return events;
        }).orElseGet(() -> this.invalidShape(shape, NodeType.OBJECT));
    }

    @Override
    public List<ValidationEvent> memberShape(MemberShape shape) {
        List<ValidationEvent> events = this.applyPlugins(shape);
        if (this.value.isNullNode()) {
            events.addAll(this.checkNullMember(shape));
        }
        this.model.getShape(shape.getTarget()).ifPresent(target -> {
            this.validationContext.setReferringMember(shape);
            events.addAll((Collection)target.accept(this));
            this.validationContext.setReferringMember(null);
        });
        return events;
    }

    public List<ValidationEvent> checkNullMember(MemberShape shape) {
        if (!this.nullableIndex.isMemberNullable(shape)) {
            switch (this.model.expectShape(shape.getContainer()).getType()) {
                case LIST: {
                    return ListUtils.of((Object)this.event(String.format("Non-sparse list shape `%s` cannot contain null values", shape.getContainer()), new String[0]));
                }
                case MAP: {
                    return ListUtils.of((Object)this.event(String.format("Non-sparse map shape `%s` cannot contain null values", shape.getContainer()), new String[0]));
                }
                case STRUCTURE: {
                    return ListUtils.of((Object)this.event(String.format("Required structure member `%s` for `%s` cannot be null", shape.getMemberName(), shape.getContainer()), new String[0]));
                }
            }
        }
        return ListUtils.of();
    }

    @Override
    public List<ValidationEvent> operationShape(OperationShape shape) {
        return this.invalidSchema(shape);
    }

    @Override
    public List<ValidationEvent> resourceShape(ResourceShape shape) {
        return this.invalidSchema(shape);
    }

    @Override
    public List<ValidationEvent> serviceShape(ServiceShape shape) {
        return this.invalidSchema(shape);
    }

    private List<ValidationEvent> invalidShape(Shape shape, NodeType expectedType) {
        block8: {
            block9: {
                if (!this.value.isNullNode() || !this.validationContext.hasFeature(Feature.ALLOW_OPTIONAL_NULLS)) break block8;
                if (!shape.isMemberShape()) break block9;
                if (!shape.asMemberShape().filter(this.nullableIndex::isMemberNullable).isPresent()) break block8;
            }
            return Collections.emptyList();
        }
        String message = String.format("Expected %s value for %s shape, `%s`; found %s value", new Object[]{expectedType, shape.getType(), shape.getId(), this.value.getType()});
        if (this.value.isStringNode()) {
            message = message + ", `" + this.value.expectStringNode().getValue() + "`";
        } else if (this.value.isNumberNode()) {
            message = message + ", `" + this.value.expectNumberNode().getValue() + "`";
        } else if (this.value.isBooleanNode()) {
            message = message + ", `" + this.value.expectBooleanNode().getValue() + "`";
        }
        return ListUtils.of((Object)this.event(message, new String[0]));
    }

    private List<ValidationEvent> invalidSchema(Shape shape) {
        return ListUtils.of((Object)this.event("Encountered invalid shape type: " + (Object)((Object)shape.getType()), new String[0]));
    }

    private ValidationEvent unknownMember(String memberName, Shape shape, Severity severity) {
        return this.event(String.format("Member `%s` does not exist in `%s`", memberName, shape.getId()), severity, "UnknownMember", shape.getId().toString(), memberName);
    }

    private ValidationEvent event(String message, String ... additionalEventIdParts) {
        return this.event(message, Severity.ERROR, additionalEventIdParts);
    }

    private ValidationEvent event(String message, Severity severity, String ... additionalEventIdParts) {
        return this.event(message, severity, this.value.getSourceLocation(), additionalEventIdParts);
    }

    private ValidationEvent event(String message, Severity severity, SourceLocation sourceLocation, String ... additionalEventIdParts) {
        return ValidationEvent.builder().id(additionalEventIdParts.length > 0 ? this.eventId + "." + String.join((CharSequence)".", additionalEventIdParts) : this.eventId).severity(severity).sourceLocation(sourceLocation).shapeId(this.eventShapeId).message(this.startingContext.isEmpty() ? message : this.startingContext + ": " + message).build();
    }

    private List<ValidationEvent> applyPlugins(Shape shape) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        this.timestampValidationStrategy.apply(shape, this.value, this.validationContext, (location, severity, message, additionalEventIdParts) -> events.add(this.event(message, severity, location.getSourceLocation(), additionalEventIdParts)));
        for (NodeValidatorPlugin plugin : BUILTIN) {
            plugin.apply(shape, this.value, this.validationContext, (location, severity, message, additionalEventIdParts) -> events.add(this.event(message, severity, location.getSourceLocation(), additionalEventIdParts)));
        }
        return events;
    }

    public static final class Builder
    implements SmithyBuilder<NodeValidationVisitor> {
        private String eventId;
        private String contextText;
        private ShapeId eventShapeId;
        private Node value;
        private Model model;
        private TimestampValidationStrategy timestampValidationStrategy = TimestampValidationStrategy.FORMAT;
        private final Set<Feature> features = new HashSet<Feature>();

        Builder() {
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder value(Node value) {
            this.value = Objects.requireNonNull(value);
            return this;
        }

        public Builder eventId(String id) {
            this.eventId = Objects.requireNonNull(id);
            return this;
        }

        public Builder startingContext(String contextText) {
            this.contextText = Objects.requireNonNull(contextText);
            return this;
        }

        public Builder eventShapeId(ShapeId eventShapeId) {
            this.eventShapeId = eventShapeId;
            return this;
        }

        public Builder timestampValidationStrategy(TimestampValidationStrategy timestampValidationStrategy) {
            this.timestampValidationStrategy = timestampValidationStrategy;
            return this;
        }

        @Deprecated
        public Builder allowBoxedNull(boolean allowBoxedNull) {
            return this.allowOptionalNull(allowBoxedNull);
        }

        @Deprecated
        public Builder allowOptionalNull(boolean allowOptionalNull) {
            if (allowOptionalNull) {
                return this.addFeature(Feature.ALLOW_OPTIONAL_NULLS);
            }
            this.features.remove((Object)Feature.ALLOW_OPTIONAL_NULLS);
            return this;
        }

        public Builder addFeature(Feature feature) {
            this.features.add(feature);
            return this;
        }

        public NodeValidationVisitor build() {
            return new NodeValidationVisitor(this);
        }
    }

    public static enum Feature {
        RANGE_TRAIT_ZERO_VALUE_WARNING,
        ALLOW_CONSTRAINT_ERRORS,
        ALLOW_OPTIONAL_NULLS,
        REQUIRE_BASE_64_BLOB_VALUES;


        public static Feature fromNode(Node node) {
            return Feature.valueOf(node.expectStringNode().getValue());
        }

        public static Node toNode(Feature feature) {
            return StringNode.from(feature.toString());
        }

        private static EnumSet<Feature> enumSet(Collection<Feature> features) {
            return features.isEmpty() ? EnumSet.noneOf(Feature.class) : EnumSet.copyOf(features);
        }
    }
}

