/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;

public final class CleanOperationStructures
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> removed, Model model) {
        return transformer.replaceShapes(model, this.getModifiedOperations(model, removed));
    }

    private Collection<Shape> getModifiedOperations(Model model, Collection<Shape> removed) {
        HashSet<ShapeId> removedIds = new HashSet<ShapeId>();
        for (Shape shape : removed) {
            removedIds.add(shape.getId());
        }
        ArrayList<Shape> modifiedShapes = new ArrayList<Shape>();
        for (OperationShape operation : model.getOperationShapes()) {
            OperationShape.Builder builder = this.transformInput(removedIds, operation);
            builder = this.transformOutput(removedIds, operation, builder);
            if ((builder = this.transformErrors(removedIds, operation, builder)) == null) continue;
            modifiedShapes.add(builder.build());
        }
        return modifiedShapes;
    }

    private OperationShape.Builder transformInput(Set<ShapeId> removed, OperationShape operation) {
        if (removed.contains(operation.getInputShape())) {
            OperationShape.Builder builder = operation.toBuilder();
            builder.input(null);
            return builder;
        }
        return null;
    }

    private OperationShape.Builder transformOutput(Set<ShapeId> removed, OperationShape operation, OperationShape.Builder builder) {
        if (removed.contains(operation.getOutputShape())) {
            if (builder == null) {
                builder = operation.toBuilder();
            }
            builder.output(null);
            return builder;
        }
        return builder;
    }

    private OperationShape.Builder transformErrors(Set<ShapeId> removed, OperationShape operation, OperationShape.Builder builder) {
        HashSet<ShapeId> errors = new HashSet<ShapeId>(operation.getErrorsSet());
        errors.removeAll(removed);
        if (errors.size() != operation.getErrorsSet().size()) {
            if (builder == null) {
                builder = operation.toBuilder();
            }
            builder.errors(errors);
            return builder;
        }
        return builder;
    }
}

