/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.IdentityClassCache;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeDeserializationException;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.StringUtils;

final class DefaultNodeDeserializers {
    private static final NodeMapper.ObjectCreatorFactory EXACT_CREATOR_FACTORY = (nodeType, targetType, nodeMapper) -> {
        Class<? extends Node> targetClass = DefaultNodeDeserializers.classFromType(targetType);
        if (targetClass != null && Node.class.isAssignableFrom(targetClass) && targetClass.isAssignableFrom(nodeType.getNodeClass())) {
            return (node, target, pointer, mapper) -> node;
        }
        return null;
    };
    private static final NodeMapper.ObjectCreatorFactory BOOLEAN_CREATOR_FACTORY = (nodeType, targetType, nodeMapper) -> {
        Class<?> targetClass;
        if (nodeType == NodeType.BOOLEAN && ((targetClass = DefaultNodeDeserializers.classFromType(targetType)) == Boolean.class || targetClass == Boolean.TYPE || targetClass == Object.class)) {
            return (node, target, pointer, mapper) -> node.expectBooleanNode().getValue();
        }
        return null;
    };
    private static final NodeMapper.ObjectCreatorFactory NULL_CREATOR = (nodeType, targetType, nodeMapper) -> {
        if (nodeType == NodeType.NULL) {
            return (node, target, pointer, mapper) -> null;
        }
        return null;
    };
    private static final NodeMapper.ObjectCreatorFactory STRING_CREATOR = (nodeType, targetType, nodeMapper) -> {
        if (nodeType == NodeType.STRING) {
            Class<?> targetClass = DefaultNodeDeserializers.classFromType(targetType);
            if (targetClass == String.class || targetClass == Object.class) {
                return (node, target, pointer, mapper) -> node.expectStringNode().getValue();
            }
            if (targetClass == ShapeId.class) {
                return (node, target, pointer, mapper) -> node.expectStringNode().expectShapeId();
            }
        }
        return null;
    };
    private static final Map<Type, Function<Number, Object>> NUMBER_MAPPERS = new HashMap<Type, Function<Number, Object>>();
    private static final NodeMapper.ObjectCreatorFactory NUMBER_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory COLLECTION_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory MAP_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory FROM_NODE_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory FROM_BUILDER_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory BEAN_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory ENUM_CREATOR;
    private static final Map<Type, FromStringClassFactory> FROM_STRING_CLASSES;
    private static final NodeMapper.ObjectCreatorFactory FROM_STRING;
    private static final NodeMapper.ObjectCreatorFactory BYTES_CREATOR;
    private static final List<NodeMapper.ObjectCreatorFactory> DEFAULT_FACTORIES;
    static final NodeMapper.ObjectCreatorFactory DEFAULT_CHAIN;
    static final NodeMapper.ObjectCreatorFactory DEFAULT_CACHED_CREATOR;

    static Class<?> classFromType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof WildcardType) {
            return DefaultNodeDeserializers.classFromType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof TypeVariable) {
            throw new IllegalArgumentException("TypeVariable targets are not implemented: " + type);
        }
        if (type instanceof GenericArrayType) {
            throw new IllegalArgumentException("GenericArrayType targets are not implemented: " + type);
        }
        return null;
    }

    private static String getCauseMessage(Throwable e) {
        return e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
    }

    private static void applySourceLocation(Object object, FromSourceLocation sourceLocation) throws ReflectiveOperationException {
        Method setter = BeanMapper.findSetter(object.getClass(), "sourceLocation");
        if (setter != null) {
            setter.invoke(object, sourceLocation.getSourceLocation());
        }
    }

    private static NodeMapper.ObjectCreatorFactory cachedCreator(NodeMapper.ObjectCreatorFactory delegate) {
        IdentityClassCache cache = new IdentityClassCache();
        return (nodeType, target, nodeMapper) -> {
            String key = nodeType.getNodeClass() + ":" + target.getTypeName();
            return cache.getForClass(key, target, () -> delegate.getCreator(nodeType, target, nodeMapper));
        };
    }

    private DefaultNodeDeserializers() {
    }

    static {
        NUMBER_MAPPERS.put((Type)((Object)Number.class), n -> n);
        NUMBER_MAPPERS.put((Type)((Object)Object.class), n -> n);
        NUMBER_MAPPERS.put((Type)((Object)Byte.class), Number::byteValue);
        NUMBER_MAPPERS.put(Byte.TYPE, Number::byteValue);
        NUMBER_MAPPERS.put((Type)((Object)Short.class), Number::shortValue);
        NUMBER_MAPPERS.put(Short.TYPE, Number::shortValue);
        NUMBER_MAPPERS.put((Type)((Object)Integer.class), Number::intValue);
        NUMBER_MAPPERS.put(Integer.TYPE, Number::intValue);
        NUMBER_MAPPERS.put((Type)((Object)Long.class), Number::longValue);
        NUMBER_MAPPERS.put(Long.TYPE, Number::longValue);
        NUMBER_MAPPERS.put((Type)((Object)Float.class), Number::floatValue);
        NUMBER_MAPPERS.put(Float.TYPE, Number::floatValue);
        NUMBER_MAPPERS.put((Type)((Object)Double.class), Number::doubleValue);
        NUMBER_MAPPERS.put(Double.TYPE, Number::doubleValue);
        NUMBER_MAPPERS.put((Type)((Object)BigInteger.class), n -> BigInteger.valueOf(n.longValue()));
        NUMBER_MAPPERS.put((Type)((Object)BigDecimal.class), n -> BigDecimal.valueOf(n.doubleValue()));
        NUMBER_CREATOR = (nodeType, targetType, nodeMapper) -> {
            Class<?> targetClass;
            if (nodeType == NodeType.NUMBER && NUMBER_MAPPERS.containsKey(targetClass = DefaultNodeDeserializers.classFromType(targetType))) {
                return (node, target, pointer, mapper) -> {
                    Number value = node.expectNumberNode().getValue();
                    return NUMBER_MAPPERS.get(targetClass).apply(value);
                };
            }
            return null;
        };
        COLLECTION_CREATOR = new NodeMapper.ObjectCreatorFactory(){

            @Override
            public NodeMapper.ObjectCreator getCreator(NodeType nodeType, Type target, NodeMapper nodeMapper) {
                if (nodeType != NodeType.ARRAY) {
                    return null;
                }
                ReflectiveSupplier<Collection<Object>> ctor = this.createSupplier(target);
                if (ctor == null) {
                    return null;
                }
                return (node, targetType, pointer, mapper) -> {
                    Type[] genericTypes;
                    Collection collection;
                    try {
                        collection = (Collection)ctor.get();
                    }
                    catch (ReflectiveOperationException e) {
                        String message = "Unable to deserialize array into Collection: " + DefaultNodeDeserializers.getCauseMessage(e);
                        throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, message);
                    }
                    Object memberType = Object.class;
                    if (targetType instanceof Class) {
                        targetType = ((Class)target).getGenericSuperclass();
                    }
                    if (targetType instanceof ParameterizedType && (genericTypes = ((ParameterizedType)targetType).getActualTypeArguments()).length > 0) {
                        memberType = genericTypes[0];
                    }
                    int i = 0;
                    for (Node entry : node.expectArrayNode().getElements()) {
                        Object nextValue = mapper.deserializeNext(entry, pointer + "/" + i++, (Type)memberType, mapper);
                        collection.add(nextValue);
                    }
                    return collection;
                };
            }

            private ReflectiveSupplier<Collection<Object>> createSupplier(Type targetType) {
                Class<?> targetClass = DefaultNodeDeserializers.classFromType(targetType);
                if (targetClass != null) {
                    if (targetClass == List.class || targetClass == Collection.class || targetClass == Object.class || targetClass == ArrayList.class || targetClass == Iterable.class) {
                        return ArrayList::new;
                    }
                    if (targetClass == Set.class || targetClass == HashSet.class || targetClass == LinkedHashSet.class) {
                        return LinkedHashSet::new;
                    }
                    if (Collection.class.isAssignableFrom(targetClass)) {
                        return this.createSupplierFromReflection(targetClass);
                    }
                }
                return null;
            }

            private ReflectiveSupplier<Collection<Object>> createSupplierFromReflection(Class<?> into) {
                try {
                    Class<?> collectionTarget = into;
                    Constructor<?> classCtor = collectionTarget.getDeclaredConstructor(new Class[0]);
                    classCtor.setAccessible(true);
                    return () -> (Collection)classCtor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new NodeDeserializationException("Unable to find a zero-arg constructor for Collection " + into.getName(), SourceLocation.NONE, (Throwable)e);
                }
            }
        };
        MAP_CREATOR = new NodeMapper.ObjectCreatorFactory(){

            @Override
            public NodeMapper.ObjectCreator getCreator(NodeType nodeType, Type target, NodeMapper nodeMapper) {
                if (nodeType != NodeType.OBJECT) {
                    return null;
                }
                ReflectiveSupplier<Map<Object, Object>> ctor = this.createSupplier(target);
                if (ctor == null) {
                    return null;
                }
                return (node, targetType, pointer, mapper) -> {
                    Map map;
                    try {
                        map = (Map)ctor.get();
                    }
                    catch (ReflectiveOperationException e) {
                        String message = "Unable to deserialize object into Map: " + DefaultNodeDeserializers.getCauseMessage(e);
                        throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, message);
                    }
                    Object keyType = Object.class;
                    Object valueType = Object.class;
                    if (targetType instanceof ParameterizedType) {
                        Type[] genericTypes = ((ParameterizedType)targetType).getActualTypeArguments();
                        if (genericTypes.length > 0) {
                            keyType = genericTypes[0];
                        }
                        if (genericTypes.length > 1) {
                            valueType = genericTypes[1];
                        }
                    }
                    ObjectNode objectNode = node.expectObjectNode();
                    for (Map.Entry<StringNode, Node> entry : objectNode.getMembers().entrySet()) {
                        String keyValue = entry.getKey().getValue();
                        Object key = mapper.deserializeNext(entry.getKey(), pointer + "/(key:" + keyValue + ")", (Type)keyType, mapper);
                        Object value = mapper.deserializeNext(entry.getValue(), pointer + "/" + keyValue, (Type)valueType, mapper);
                        map.put(key, value);
                    }
                    return map;
                };
            }

            private ReflectiveSupplier<Map<Object, Object>> createSupplier(Type into) {
                Class<?> targetClass = DefaultNodeDeserializers.classFromType(into);
                if (targetClass != null) {
                    if (targetClass == Object.class || targetClass == Map.class || targetClass == HashMap.class) {
                        return HashMap::new;
                    }
                    if (Map.class.isAssignableFrom(targetClass)) {
                        return this.createSupplierFromReflection(targetClass);
                    }
                }
                return null;
            }

            private ReflectiveSupplier<Map<Object, Object>> createSupplierFromReflection(Class<?> into) {
                try {
                    Class<?> collectionTarget = into;
                    Constructor<?> mapCtor = collectionTarget.getDeclaredConstructor(new Class[0]);
                    return () -> (Map)mapCtor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new NodeDeserializationException("Unable to find a zero-arg constructor for Map " + into.getName(), SourceLocation.NONE, (Throwable)e);
                }
            }
        };
        FROM_NODE_CREATOR = (nodeType, target, nodeMapper) -> {
            Class<?> targetClass = DefaultNodeDeserializers.classFromType(target);
            if (targetClass != null && !nodeMapper.getDisableFromNode().contains(targetClass)) {
                for (Method method : targetClass.getMethods()) {
                    if (!method.getName().equals("fromNode") || !targetClass.isAssignableFrom(method.getReturnType()) || method.getParameters().length != 1 || !Node.class.isAssignableFrom(method.getParameters()[0].getType()) || !Modifier.isStatic(method.getModifiers())) continue;
                    return (node, targetType, pointer, mapper) -> {
                        try {
                            return method.invoke(null, node);
                        }
                        catch (ReflectiveOperationException e) {
                            String message = "Unable to deserialize Node using fromNode method: " + DefaultNodeDeserializers.getCauseMessage(e);
                            throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, message);
                        }
                    };
                }
            }
            return null;
        };
        FROM_BUILDER_CREATOR = (nodeType, target, nodeMapper) -> {
            Class<?> targetClass = DefaultNodeDeserializers.classFromType(target);
            if (nodeType != NodeType.OBJECT || targetClass == null) {
                return null;
            }
            for (Method method : targetClass.getMethods()) {
                if (!method.getName().equals("builder") || !SmithyBuilder.class.isAssignableFrom(method.getReturnType()) || method.getParameters().length != 0 || !Modifier.isStatic(method.getModifiers())) continue;
                method.setAccessible(true);
                return (node, targetType, pointer, mapper) -> {
                    try {
                        SmithyBuilder builder = (SmithyBuilder)method.invoke(null, new Object[0]);
                        BeanMapper.apply(builder, node, builder.getClass(), pointer, mapper);
                        DefaultNodeDeserializers.applySourceLocation(builder, node);
                        return builder.build();
                    }
                    catch (ReflectiveOperationException e) {
                        String message = "Unable to deserialize Node using a builder: " + DefaultNodeDeserializers.getCauseMessage(e);
                        throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, message);
                    }
                };
            }
            return null;
        };
        BEAN_CREATOR = (nodeType, target, nodeMapper) -> {
            Class<?> targetClass = DefaultNodeDeserializers.classFromType(target);
            if (nodeType != NodeType.OBJECT || targetClass == null) {
                return null;
            }
            try {
                if (targetClass.getEnclosingClass() != null && !Modifier.isStatic(targetClass.getModifiers())) {
                    throw new NodeDeserializationException("Cannot create non-static inner class: " + targetClass.getCanonicalName(), SourceLocation.NONE);
                }
                Constructor<?> ctor = targetClass.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                return (node, targetType, pointer, mapper) -> {
                    try {
                        Object value = ctor.newInstance(new Object[0]);
                        BeanMapper.apply(value, node, targetType, pointer, mapper);
                        DefaultNodeDeserializers.applySourceLocation(value, node);
                        return value;
                    }
                    catch (ReflectiveOperationException e) {
                        throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, "Unable to deserialize a Node when invoking target constructor: " + DefaultNodeDeserializers.getCauseMessage(e));
                    }
                };
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        };
        ENUM_CREATOR = (nodeType, target, nodeMapper) -> {
            Class<?> targetClass = DefaultNodeDeserializers.classFromType(target);
            if (nodeType != NodeType.STRING || targetClass == null || !Enum.class.isAssignableFrom(targetClass)) {
                return null;
            }
            return (node, targetType, pointer, mapper) -> {
                String name = node.expectStringNode().getValue();
                for (Object constant : targetClass.getEnumConstants()) {
                    if (!constant.toString().equals(name)) continue;
                    return constant;
                }
                ArrayList<String> names = new ArrayList<String>();
                for (Object constant : targetClass.getEnumConstants()) {
                    names.add(constant.toString());
                }
                throw NodeDeserializationException.fromContext(targetClass, pointer, node, null, "Expected one of the following enum strings: " + names);
            };
        };
        FROM_STRING_CLASSES = MapUtils.of(URL.class, URL::new, URI.class, URI::new, Pattern.class, Pattern::compile, Path.class, x$0 -> Paths.get(x$0, new String[0]), File.class, File::new);
        FROM_STRING = (nodeType, target, nodeMapper) -> {
            if (nodeType != NodeType.STRING || !FROM_STRING_CLASSES.containsKey(target)) {
                return null;
            }
            FromStringClassFactory factory = FROM_STRING_CLASSES.get(target);
            return (node, targetType, pointer, mapper) -> {
                String value = node.expectStringNode().getValue();
                try {
                    return factory.create(value);
                }
                catch (Exception e) {
                    throw NodeDeserializationException.fromContext(targetType, pointer, node, e, e.getMessage());
                }
            };
        };
        BYTES_CREATOR = (nodeType, target, nodeMapper) -> {
            if (nodeType != NodeType.STRING || target != byte[].class) {
                return null;
            }
            return (node, targetType, pointer, mapper) -> {
                String value = node.expectStringNode().getValue();
                try {
                    return Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    throw NodeDeserializationException.fromContext(targetType, pointer, node, e, e.getMessage());
                }
            };
        };
        DEFAULT_FACTORIES = ListUtils.of((Object[])new NodeMapper.ObjectCreatorFactory[]{EXACT_CREATOR_FACTORY, NULL_CREATOR, FROM_NODE_CREATOR, BOOLEAN_CREATOR_FACTORY, BYTES_CREATOR, FROM_STRING, STRING_CREATOR, ENUM_CREATOR, NUMBER_CREATOR, COLLECTION_CREATOR, MAP_CREATOR, FROM_BUILDER_CREATOR, BEAN_CREATOR});
        DEFAULT_CHAIN = (nodeType, target, nodeMapper) -> {
            for (NodeMapper.ObjectCreatorFactory factory : DEFAULT_FACTORIES) {
                NodeMapper.ObjectCreator result = factory.getCreator(nodeType, target, nodeMapper);
                if (result == null) continue;
                return result;
            }
            return null;
        };
        DEFAULT_CACHED_CREATOR = DefaultNodeDeserializers.cachedCreator(DEFAULT_CHAIN);
    }

    static final class BeanMapper {
        private static final ConcurrentMap<Pair<Class<?>, String>, Method> SETTER_CACHE = new ConcurrentHashMap();

        BeanMapper() {
        }

        static void apply(Object value, Node node, Type target, String pointer, NodeMapper mapper) throws ReflectiveOperationException {
            for (Map.Entry<String, Node> entry : node.expectObjectNode().getStringMap().entrySet()) {
                Method setter = BeanMapper.findSetter(target, entry.getKey());
                if (setter == null) {
                    mapper.getWhenMissingSetter().handle(target, pointer, entry.getKey(), entry.getValue());
                    continue;
                }
                Object member = mapper.deserializeNext(entry.getValue(), pointer + "/" + entry.getKey(), setter.getParameters()[0].getParameterizedType(), mapper);
                setter.invoke(value, member);
            }
        }

        private static Method findSetter(Type type, String memberName) {
            Class<?> targetType = DefaultNodeDeserializers.classFromType(type);
            if (targetType == null) {
                return null;
            }
            return SETTER_CACHE.computeIfAbsent(Pair.of(targetType, (Object)memberName), pair -> {
                String sanitized = BeanMapper.sanitizePropertyName((String)pair.right);
                if (sanitized != null) {
                    for (Method method : targetType.getMethods()) {
                        if (!BeanMapper.isBeanOrBuilderSetter(method, targetType, sanitized)) continue;
                        return method;
                    }
                }
                return null;
            });
        }

        private static String sanitizePropertyName(String value) {
            StringBuilder result = new StringBuilder(value.length());
            boolean nextUpper = false;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    if (nextUpper) {
                        return null;
                    }
                    nextUpper = true;
                    continue;
                }
                if (nextUpper) {
                    nextUpper = false;
                    result.append(Character.toUpperCase(c));
                    continue;
                }
                result.append(c);
            }
            return result.toString();
        }

        private static boolean isBeanOrBuilderSetter(Method method, Class<?> type, String propertyName) {
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            Parameter[] parameters = method.getParameters();
            if (parameters.length != 1) {
                return false;
            }
            if (method.getReturnType() != Void.TYPE && !method.getReturnType().isAssignableFrom(type)) {
                return false;
            }
            if (method.getName().equals(propertyName)) {
                return true;
            }
            return method.getName().equals("set" + StringUtils.capitalize((String)propertyName));
        }
    }

    private static interface FromStringClassFactory {
        public Object create(String var1) throws Exception;
    }

    private static interface ReflectiveSupplier<T> {
        public T get() throws ReflectiveOperationException;
    }
}

