/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import software.amazon.smithy.model.node.Node;

final class NodeQuery {
    private static final Query SELF = (node, result) -> result.add(node);
    private static final Query ANY_MEMBER = (node, result) -> {
        if (node == null || !node.isObjectNode()) {
            return;
        }
        result.addAll(node.expectObjectNode().getMembers().values());
    };
    private static final Query ANY_ELEMENT = (node, result) -> {
        if (node == null || !node.isArrayNode()) {
            return;
        }
        result.addAll(node.expectArrayNode().getElements());
    };
    private static final Query ANY_MEMBER_NAME = (node, result) -> {
        if (node == null || !node.isObjectNode()) {
            return;
        }
        result.addAll(node.expectObjectNode().getMembers().keySet());
    };
    private final List<Query> queries = new ArrayList<Query>();

    NodeQuery() {
    }

    NodeQuery self() {
        this.queries.add(SELF);
        return this;
    }

    NodeQuery member(String name) {
        this.queries.add((node, result) -> {
            if (node == null || !node.isObjectNode()) {
                return;
            }
            node.expectObjectNode().getMember(name).ifPresent(result::add);
        });
        return this;
    }

    NodeQuery anyMember() {
        this.queries.add(ANY_MEMBER);
        return this;
    }

    NodeQuery anyElement() {
        this.queries.add(ANY_ELEMENT);
        return this;
    }

    NodeQuery anyMemberName() {
        this.queries.add(ANY_MEMBER_NAME);
        return this;
    }

    Collection<Node> execute(Node node) {
        ArrayDeque<Node> previousResult = new ArrayDeque<Node>();
        if (this.queries.isEmpty()) {
            return previousResult;
        }
        previousResult.add(node);
        for (Query query : this.queries) {
            for (int i = previousResult.size(); i > 0; --i) {
                query.run((Node)previousResult.poll(), previousResult);
            }
        }
        return previousResult;
    }

    @FunctionalInterface
    static interface Query {
        public void run(Node var1, Queue<Node> var2);
    }
}

