/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.traits.UnitTypeTrait;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class OperationShape
extends Shape
implements ToSmithyBuilder<OperationShape> {
    private final ShapeId input;
    private final ShapeId output;
    private final Set<ShapeId> errors;
    private final Set<ShapeId> introducedErrors;

    private OperationShape(Builder builder) {
        super(builder, false);
        this.input = Objects.requireNonNull(builder.input);
        this.output = Objects.requireNonNull(builder.output);
        if (this.getMixins().isEmpty()) {
            this.errors = (Set)builder.errors.copy();
            this.introducedErrors = this.errors;
        } else {
            LinkedHashSet<ShapeId> computedErrors = new LinkedHashSet<ShapeId>();
            for (Shape shape : builder.getMixins().values()) {
                shape.asOperationShape().ifPresent(mixin -> computedErrors.addAll(mixin.getErrorsSet()));
            }
            this.introducedErrors = (Set)builder.errors.copy();
            computedErrors.addAll(this.introducedErrors);
            this.errors = Collections.unmodifiableSet(new LinkedHashSet(computedErrors));
        }
        if (!(!this.hasTrait(MixinTrait.ID) || this.input.equals(UnitTypeTrait.UNIT) && this.output.equals(UnitTypeTrait.UNIT))) {
            throw new SourceException(String.format("Operation shapes with the mixin trait MUST target `%s` for their input and output. Operation mixin shape `%s` defines one or both of these properties.", UnitTypeTrait.UNIT, this.getId()), builder.getSourceLocation());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return this.updateBuilder(OperationShape.builder()).input(this.input).output(this.output).errors(this.getIntroducedErrorsSet());
    }

    @Override
    public <R> R accept(ShapeVisitor<R> visitor) {
        return visitor.operationShape(this);
    }

    @Override
    public Optional<OperationShape> asOperationShape() {
        return Optional.of(this);
    }

    @Override
    public ShapeType getType() {
        return ShapeType.OPERATION;
    }

    public Optional<ShapeId> getInput() {
        return this.input.equals(UnitTypeTrait.UNIT) ? Optional.empty() : Optional.of(this.input);
    }

    public Optional<ShapeId> getOutput() {
        return this.output.equals(UnitTypeTrait.UNIT) ? Optional.empty() : Optional.of(this.output);
    }

    public ShapeId getInputShape() {
        return this.input;
    }

    public ShapeId getOutputShape() {
        return this.output;
    }

    @Deprecated
    public List<ShapeId> getErrors() {
        return ListUtils.copyOf(this.errors);
    }

    public Set<ShapeId> getErrorsSet() {
        return this.errors;
    }

    @Deprecated
    public List<ShapeId> getIntroducedErrors() {
        return ListUtils.copyOf(this.introducedErrors);
    }

    public Set<ShapeId> getIntroducedErrorsSet() {
        return this.introducedErrors;
    }

    public List<ShapeId> getErrors(ServiceShape service) {
        LinkedHashSet<ShapeId> result = new LinkedHashSet<ShapeId>(service.getErrorsSet());
        result.addAll(this.getErrorsSet());
        return new ArrayList<ShapeId>(result);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        OperationShape otherShape = (OperationShape)other;
        return this.input.equals(otherShape.input) && this.output.equals(otherShape.output) && this.errors.equals(otherShape.errors);
    }

    public static final class Builder
    extends AbstractShapeBuilder<Builder, OperationShape> {
        private ShapeId input = UnitTypeTrait.UNIT;
        private ShapeId output = UnitTypeTrait.UNIT;
        private final BuilderRef<Set<ShapeId>> errors = BuilderRef.forOrderedSet();

        @Override
        public ShapeType getShapeType() {
            return ShapeType.OPERATION;
        }

        public Builder input(ToShapeId inputShape) {
            this.input = inputShape == null ? UnitTypeTrait.UNIT : inputShape.toShapeId();
            return this;
        }

        public Builder output(ToShapeId outputShape) {
            this.output = outputShape == null ? UnitTypeTrait.UNIT : outputShape.toShapeId();
            return this;
        }

        public Builder errors(Collection<ShapeId> errorShapeIds) {
            this.errors.clear();
            errorShapeIds.forEach(this::addError);
            return this;
        }

        public Builder addError(ToShapeId errorShapeId) {
            ((Set)this.errors.get()).add(errorShapeId.toShapeId());
            return this;
        }

        public Builder addError(String errorShapeId) {
            return this.addError(ShapeId.from(errorShapeId));
        }

        public Builder addErrors(Collection<ShapeId> errorShapeIds) {
            ((Set)this.errors.get()).addAll(Objects.requireNonNull(errorShapeIds));
            return this;
        }

        public Builder removeError(ToShapeId errorShapeId) {
            ((Set)this.errors.get()).remove(errorShapeId.toShapeId());
            return this;
        }

        public Builder clearErrors() {
            this.errors.clear();
            return this;
        }

        public OperationShape build() {
            return new OperationShape(this);
        }

        @Override
        public Builder flattenMixins() {
            if (this.getMixins().isEmpty()) {
                return this;
            }
            LinkedHashSet<ShapeId> computedErrors = new LinkedHashSet<ShapeId>();
            for (Shape shape : this.getMixins().values()) {
                shape.asOperationShape().ifPresent(mixin -> computedErrors.addAll(mixin.getErrorsSet()));
            }
            computedErrors.addAll((Collection)this.errors.peek());
            this.errors(computedErrors);
            return (Builder)super.flattenMixins();
        }
    }
}

