/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.IdentifierBindingIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ResourceIdentifierTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public final class ResourceIdentifierBindingValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        this.validateResourceIdentifierTraits(model, events);
        this.validateOperationBindings(model, events);
        return events;
    }

    private void validateResourceIdentifierTraits(Model model, List<ValidationEvent> events) {
        for (ShapeId container : this.findStructuresWithResourceIdentifierTraits(model)) {
            if (!model.getShape(container).isPresent()) continue;
            Shape structure = model.expectShape(container);
            Map<String, Set<String>> bindings = this.computePotentialStructureBindings(structure);
            for (Map.Entry<String, Set<String>> entry : bindings.entrySet()) {
                if (entry.getValue().size() <= 1 || !entry.getValue().contains(entry.getKey())) continue;
                Set<String> explicitBindings = entry.getValue();
                explicitBindings.remove(entry.getKey());
                events.add(this.warning(structure, String.format("Implicit resource identifier for '%s' is overridden by `resourceIdentifier` trait on members: '%s'", entry.getKey(), String.join((CharSequence)"', '", explicitBindings))));
            }
            this.validateResourceIdentifierTraitConflicts(structure, events);
        }
    }

    private Set<ShapeId> findStructuresWithResourceIdentifierTraits(Model model) {
        HashSet<ShapeId> containers = new HashSet<ShapeId>();
        for (MemberShape member : model.getMemberShapesWithTrait(ResourceIdentifierTrait.class)) {
            containers.add(member.getContainer());
        }
        return containers;
    }

    private Map<String, Set<String>> computePotentialStructureBindings(Shape structure) {
        HashMap<String, Set<String>> bindings = new HashMap<String, Set<String>>();
        for (MemberShape member : structure.members()) {
            String bindingName = member.getTrait(ResourceIdentifierTrait.class).map(StringTrait::getValue).orElseGet(member::getMemberName);
            bindings.computeIfAbsent(bindingName, k -> new HashSet()).add(member.getMemberName());
        }
        return bindings;
    }

    private void validateResourceIdentifierTraitConflicts(Shape structure, List<ValidationEvent> events) {
        HashMap<String, Set> explicitBindings = new HashMap<String, Set>();
        for (MemberShape memberShape : structure.members()) {
            if (!memberShape.hasTrait(ResourceIdentifierTrait.ID)) continue;
            explicitBindings.computeIfAbsent(memberShape.expectTrait(ResourceIdentifierTrait.class).getValue(), k -> new HashSet()).add(memberShape.getMemberName());
        }
        for (Map.Entry entry : explicitBindings.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            events.add(this.error(structure, String.format("Conflicting resource identifier member bindings found for identifier '%s' between members: '%s'", entry.getKey(), String.join((CharSequence)"', '", (Iterable)entry.getValue()))));
        }
    }

    private void validateOperationBindings(Model model, List<ValidationEvent> events) {
        IdentifierBindingIndex bindingIndex = IdentifierBindingIndex.of(model);
        for (ResourceShape resource : model.getResourceShapes()) {
            this.validateResource(model, resource, bindingIndex, events);
            this.validateCollectionBindings(model, resource, bindingIndex, events);
            this.validateInstanceBindings(model, resource, bindingIndex, events);
        }
    }

    private void validateResource(Model model, ResourceShape parent, IdentifierBindingIndex bindingIndex, List<ValidationEvent> events) {
        for (ShapeId childId : parent.getResources()) {
            ResourceShape child = model.expectShape(childId, ResourceShape.class);
            for (ShapeId operationId : child.getAllOperations()) {
                OperationShape operation = model.expectShape(operationId, OperationShape.class);
                this.validateOperation(parent, child, operation, bindingIndex).ifPresent(events::add);
            }
        }
    }

    private Optional<ValidationEvent> validateOperation(ResourceShape parent, ResourceShape child, OperationShape operation, IdentifierBindingIndex bindingIndex) {
        if (bindingIndex.getOperationBindingType(child, operation) != IdentifierBindingIndex.BindingType.NONE) {
            Set<String> bindings = bindingIndex.getOperationInputBindings(child, operation).keySet();
            LinkedHashSet<String> missing = new LinkedHashSet<String>(parent.getIdentifiers().keySet());
            missing.removeAll(bindings);
            if (!missing.isEmpty()) {
                return Optional.of(this.error(operation, String.format("This operation is bound to the `%s` resource, which is a child of the `%s` resource, and it is missing the following resource identifier bindings of `%s`: [%s]", child.getId(), parent.getId(), parent.getId(), ValidationUtils.tickedList(missing))));
            }
        }
        return Optional.empty();
    }

    private void validateCollectionBindings(Model model, ResourceShape resource, IdentifierBindingIndex bindingIndex, List<ValidationEvent> events) {
        for (ShapeId operationId : resource.getAllOperations()) {
            OperationShape operation;
            if (bindingIndex.getOperationBindingType(resource, operationId) != IdentifierBindingIndex.BindingType.COLLECTION || !this.hasAllIdentifiersBound(model, resource, operation = model.expectShape(operationId, OperationShape.class), bindingIndex)) continue;
            events.add(this.error(operation, String.format("This operation is bound as a collection operation on the `%s` resource, but it improperly binds all of the identifiers of the resource to members of the operation input.", resource.getId())));
        }
    }

    private void validateInstanceBindings(Model model, ResourceShape resource, IdentifierBindingIndex bindingIndex, List<ValidationEvent> events) {
        for (ShapeId operationId : resource.getAllOperations()) {
            OperationShape operation;
            if (bindingIndex.getOperationBindingType(resource, operationId) != IdentifierBindingIndex.BindingType.INSTANCE || this.hasAllIdentifiersBound(model, resource, operation = model.expectShape(operationId, OperationShape.class), bindingIndex)) continue;
            String expectedIdentifiers = this.createBindingMessage(resource.getIdentifiers());
            String boundIds = this.createBindingMessage(bindingIndex.getOperationInputBindings(resource, operation));
            events.add(this.error(operation, String.format("This operation does not form a valid instance operation when bound to resource `%s`. All of the identifiers of the resource were not implicitly or explicitly bound to the input of the operation. Expected the following identifier bindings: [%s]. Found the following identifier bindings: [%s]", resource.getId(), expectedIdentifiers, boundIds)));
        }
    }

    private boolean hasAllIdentifiersBound(Model model, ResourceShape resource, OperationShape operation, IdentifierBindingIndex bindingIndex) {
        StructureShape inputShape = model.expectShape(operation.getInputShape(), StructureShape.class);
        Map<String, String> bindings = bindingIndex.getOperationInputBindings(resource, operation);
        for (Map.Entry<String, ShapeId> identifier : resource.getIdentifiers().entrySet()) {
            if (!bindings.containsKey(identifier.getKey())) {
                return false;
            }
            MemberShape identifierMember = inputShape.getMember(bindings.get(identifier.getKey())).get();
            if (identifierMember.getTarget().equals(identifier.getValue())) continue;
            return false;
        }
        return true;
    }

    private String createBindingMessage(Map<String, ?> bindings) {
        return bindings.entrySet().stream().map(entry -> String.format("required member named `%s` that targets `%s`", entry.getKey(), entry.getValue().toString())).sorted().collect(Collectors.joining(", "));
    }
}

