/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public final class HttpLabelTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : model.getOperationShapesWithTrait(HttpTrait.class)) {
            events.addAll(this.validateStructure(model, operation, operation.expectTrait(HttpTrait.class)));
        }
        return events;
    }

    private List<ValidationEvent> validateStructure(Model model, OperationShape operation, HttpTrait http) {
        return this.validateBindings(model, operation, http, model.expectShape(operation.getInputShape(), StructureShape.class));
    }

    private List<ValidationEvent> validateBindings(Model model, OperationShape operation, HttpTrait http, StructureShape input) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Set labels = http.getUri().getLabels().stream().map(SmithyPattern.Segment::getContent).collect(Collectors.toSet());
        for (MemberShape member : input.getAllMembers().values()) {
            member.getTrait(HttpLabelTrait.class).ifPresent(trait -> {
                labels.remove(member.getMemberName());
                if (!http.getUri().getLabel(member.getMemberName()).isPresent()) {
                    events.add(this.error((Shape)member, (FromSourceLocation)trait, String.format("This `%s` structure member is marked with the `httpLabel` trait, but no corresponding `http` URI label could be found when used as the input of the `%s` operation.", member.getMemberName(), operation.getId())));
                } else if (http.getUri().getLabel(member.getMemberName()).get().isGreedyLabel()) {
                    model.getShape(member.getTarget()).ifPresent(target -> {
                        if (!target.isStringShape()) {
                            events.add(this.error((Shape)member, (FromSourceLocation)trait, String.format("The `%s` structure member corresponds to a greedy label when used as the input of the `%s` operation. This member targets %s, but greedy labels must target string shapes.", member.getMemberName(), operation.getId(), target)));
                        }
                    });
                }
            });
        }
        if (!labels.isEmpty()) {
            events.add(this.error(operation, String.format("This operation uses `%s` as input, but the following URI labels found in the operation's `http` trait do not have a corresponding member marked with the `httpLabel` trait: %s", input.getId(), ValidationUtils.tickedList(labels))));
        }
        return events;
    }
}

