/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.NodePointer;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TraitBreakingChangesValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(TraitDefinition.class)) {
            this.validateTrait(model, shape, events);
        }
        return events;
    }

    private void validateTrait(Model model, Shape shape, List<ValidationEvent> events) {
        TraitDefinition trait = shape.expectTrait(TraitDefinition.class);
        block0: for (int i = 0; i < trait.getBreakingChanges().size(); ++i) {
            TraitDefinition.BreakingChangeRule diffRule = trait.getBreakingChanges().get(i);
            if (!diffRule.getPath().isPresent() || diffRule.getPath().get().toString().equals("")) continue;
            Shape current = shape;
            NodePointer pointer = diffRule.getPath().get();
            int segment = 0;
            for (String part : pointer.getParts()) {
                Shape previous = current;
                if ((current = (Shape)current.getMember(part).flatMap(member -> model.getShape(member.getTarget())).orElse(null)) == null) {
                    events.add(this.emit(shape, i, segment, previous));
                    continue block0;
                }
                ++segment;
            }
        }
    }

    private ValidationEvent emit(Shape shape, int element, int segment, Shape evaluated) {
        TraitDefinition definition = shape.expectTrait(TraitDefinition.class);
        NodePointer path = definition.getBreakingChanges().get(element).getDefaultedPath();
        return this.error(shape, definition, String.format("Invalid trait breakingChanges element %d, '%s', at segment '%s': Evaluated shape `%s`, a %s, has no member named `%s`", new Object[]{element, path, path.getParts().get(segment), evaluated.getId(), evaluated.getType(), path.getParts().get(segment)}));
    }
}

