/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.Shape;

final class MarkAndSweep {
    private final Predicate<Shape> sweepFilter;
    private final Consumer<MarkerContext> marker;

    MarkAndSweep(Consumer<MarkerContext> marker, Predicate<Shape> sweepFilter) {
        this.marker = marker;
        this.sweepFilter = sweepFilter;
    }

    Set<Shape> markAndSweep(Model model) {
        int currentSize;
        NeighborProvider reverseNeighbors = NeighborProvider.reverse(model);
        MarkerContext context = new MarkerContext(reverseNeighbors, model, this.sweepFilter);
        do {
            currentSize = context.getMarkedForRemoval().size();
            this.marker.accept(context);
            model.shapes().filter(shape -> !shape.isMemberShape()).forEach(shape -> {
                Set<Shape> targetedFrom;
                if (!context.getMarkedForRemoval().contains(shape) && !(targetedFrom = context.getTargetedFrom((Shape)shape)).isEmpty()) {
                    targetedFrom.removeAll(context.getMarkedForRemoval());
                    if (targetedFrom.isEmpty()) {
                        context.markShape((Shape)shape);
                    }
                }
            });
        } while (currentSize != context.getMarkedForRemoval().size());
        return context.getMarkedForRemoval();
    }

    static final class MarkerContext {
        private final NeighborProvider reverseProvider;
        private final Model model;
        private final Set<Shape> markedForRemoval = new HashSet<Shape>();
        private final Predicate<Shape> sweepFilter;

        MarkerContext(NeighborProvider reverseProvider, Model model, Predicate<Shape> sweepFilter) {
            this.reverseProvider = reverseProvider;
            this.model = model;
            this.sweepFilter = sweepFilter;
        }

        Model getModel() {
            return this.model;
        }

        Set<Shape> getMarkedForRemoval() {
            return Collections.unmodifiableSet(this.markedForRemoval);
        }

        void markShape(Shape shape) {
            if (this.sweepFilter.test(shape)) {
                this.markedForRemoval.add(shape);
                this.markedForRemoval.addAll(shape.members());
            }
        }

        Set<Shape> getTargetedFrom(Shape shape) {
            return this.findRelationshipsTo(shape).map(Relationship::getShape).collect(Collectors.toSet());
        }

        private Stream<Relationship> findRelationshipsTo(Shape shape) {
            return this.reverseProvider.getNeighbors(shape).stream().filter(rel -> {
                RelationshipType type = rel.getRelationshipType();
                return type.getDirection() == RelationshipDirection.DIRECTED && !type.isMemberBinding();
            }).filter(rel -> rel.getRelationshipType() != RelationshipType.MEMBER_TARGET || !rel.getShape().getId().withoutMember().equals(rel.getNeighborShapeId()));
        }
    }
}

