/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

public final class Relationship {
    private final Shape shape;
    private final RelationshipType relationshipType;
    private final ShapeId neighborShapeId;
    private final Shape neighborShape;

    private Relationship(Shape shape, RelationshipType relationshipType, ShapeId neighborShapeId, Shape neighborShape) {
        this.shape = Objects.requireNonNull(shape);
        this.relationshipType = Objects.requireNonNull(relationshipType);
        this.neighborShapeId = Objects.requireNonNull(neighborShapeId);
        this.neighborShape = neighborShape;
    }

    public static Relationship create(Shape shape, RelationshipType relationshipType, Shape neighborShape) {
        return new Relationship(shape, relationshipType, neighborShape.getId(), neighborShape);
    }

    public static Relationship createInvalid(Shape shape, RelationshipType relationshipType, ShapeId neighborShapeId) {
        return new Relationship(shape, relationshipType, neighborShapeId, null);
    }

    public Shape getShape() {
        return this.shape;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public ShapeId getNeighborShapeId() {
        return this.neighborShapeId;
    }

    public Optional<Shape> getNeighborShape() {
        return Optional.ofNullable(this.neighborShape);
    }

    public Shape expectNeighborShape() {
        if (this.neighborShape == null) {
            throw new ExpectationNotMetException("Neighbor does not exist: " + this.neighborShapeId, this.shape);
        }
        return this.neighborShape;
    }

    public Optional<String> getSelectorLabel() {
        return this.relationshipType.getSelectorLabel();
    }

    public RelationshipDirection getDirection() {
        return this.relationshipType.getDirection();
    }

    public String toString() {
        return String.format("[Relationship shape=\"%s\" type=\"%s\" neighbor=\"%s\" neighborPresent=%b]", new Object[]{this.shape.getId(), this.relationshipType, this.neighborShapeId, this.neighborShape != null});
    }

    public boolean equals(Object other) {
        if (!(other instanceof Relationship)) {
            return false;
        }
        Relationship otherRelationship = (Relationship)other;
        return this.shape.equals(otherRelationship.shape) && this.relationshipType.equals((Object)otherRelationship.relationshipType) && this.neighborShapeId.equals(otherRelationship.neighborShapeId) && Objects.equals(this.neighborShape, otherRelationship.neighborShape);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shape, this.relationshipType, this.neighborShapeId});
    }
}

