/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.SmithyBuilder;

public class ModelSyntaxException
extends SourceException
implements ToShapeId {
    private final ShapeId shapeId;

    public ModelSyntaxException(String message, int line, int column) {
        this(ModelSyntaxException.builder().message(message).sourceLocation(line, column));
    }

    public ModelSyntaxException(String message, String filename, int line, int column) {
        this(ModelSyntaxException.builder().message(message).sourceLocation(filename, line, column));
    }

    public ModelSyntaxException(String message, FromSourceLocation sourceLocation) {
        this(ModelSyntaxException.builder().message(message).sourceLocation(sourceLocation.getSourceLocation()));
    }

    private ModelSyntaxException(Builder builder) {
        super(builder.message, builder.sourceLocation);
        this.shapeId = builder.shapeId;
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    public ShapeId toShapeId() {
        return this.shapeId;
    }

    static final class Builder
    implements SmithyBuilder<ModelSyntaxException> {
        private SourceLocation sourceLocation = SourceLocation.NONE;
        private ShapeId shapeId = null;
        private String message;

        private Builder() {
        }

        public ModelSyntaxException build() {
            SmithyBuilder.requiredState((String)"message", (Object)this.message);
            return new ModelSyntaxException(this);
        }

        Builder shapeId(ShapeId shapeId) {
            this.shapeId = shapeId;
            return this;
        }

        Builder message(String message) {
            this.message = message;
            return this;
        }

        Builder sourceLocation(FromSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation.getSourceLocation();
            return this;
        }

        Builder sourceLocation(String filename, int line, int column) {
            return this.sourceLocation(new SourceLocation(filename, line, column));
        }

        Builder sourceLocation(int line, int column) {
            return this.sourceLocation(SourceLocation.NONE.getFilename(), line, column);
        }
    }
}

