/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Iterator;
import java.util.function.Predicate;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class RecursiveNeighborSelector
implements InternalSelector {
    private static final Predicate<Relationship> ONLY_DIRECTED = r -> r.getRelationshipType().getDirection() == RelationshipDirection.DIRECTED;

    RecursiveNeighborSelector() {
    }

    @Override
    public InternalSelector.Response push(Context context, Shape shape, InternalSelector.Receiver next) {
        Walker walker = new Walker(context.neighborIndex.getProvider());
        Iterator<Shape> shapeIterator = walker.iterateShapes(shape, ONLY_DIRECTED);
        while (shapeIterator.hasNext()) {
            Shape nextShape = shapeIterator.next();
            if (nextShape.equals(shape) || next.apply(context, nextShape) != InternalSelector.Response.STOP) continue;
            return InternalSelector.Response.STOP;
        }
        return InternalSelector.Response.CONTINUE;
    }
}

