/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;

public final class AuthTrait
extends AbstractTrait {
    public static final ShapeId ID = ShapeId.from("smithy.api#auth");
    private final Set<ShapeId> values;

    @Deprecated
    public AuthTrait(List<ShapeId> values, FromSourceLocation sourceLocation) {
        super(ID, sourceLocation);
        this.values = SetUtils.orderedCopyOf(values);
    }

    @Deprecated
    public AuthTrait(List<ShapeId> values) {
        this(values, (FromSourceLocation)SourceLocation.NONE);
    }

    public AuthTrait(Set<ShapeId> values, FromSourceLocation sourceLocation) {
        super(ID, sourceLocation);
        this.values = SetUtils.orderedCopyOf(values);
    }

    public AuthTrait(Set<ShapeId> values) {
        this(values, (FromSourceLocation)SourceLocation.NONE);
    }

    public Set<ShapeId> getValueSet() {
        return this.values;
    }

    @Deprecated
    public List<ShapeId> getValues() {
        return ListUtils.copyOf(this.values);
    }

    @Override
    protected Node createNode() {
        return this.getValueSet().stream().map(ShapeId::toString).map(Node::from).collect(ArrayNode.collect(this.getSourceLocation()));
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            ArrayNode arrayNode = value.expectArrayNode();
            List<ShapeId> values = arrayNode.getElementsAs(ShapeId::fromNode);
            AuthTrait trait = new AuthTrait(values, (FromSourceLocation)value.getSourceLocation());
            trait.setNodeCache(value);
            return trait;
        }
    }
}

