/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.linters;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;

public final class EmitNoneSelectorValidator
extends AbstractValidator {
    private final Config config;

    private EmitNoneSelectorValidator(Config config) {
        this.config = config;
        Objects.requireNonNull(config.selector, "selector is required");
    }

    @Override
    public List<ValidationEvent> validate(Model model) {
        Set shapes = this.config.getSelector().select(model).stream().filter(shape -> !Prelude.isPreludeShape(shape.getId())).collect(Collectors.toSet());
        if (shapes.isEmpty()) {
            return ListUtils.of((Object)ValidationEvent.builder().id(this.getName()).severity(Severity.DANGER).message("Expected at least one shape to match selector: " + this.config.getSelector()).build());
        }
        return ListUtils.of();
    }

    public static final class Config {
        private Selector selector;

        public Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Selector selector) {
            this.selector = selector;
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(EmitNoneSelectorValidator.class, (ObjectNode configuration) -> {
                NodeMapper mapper = new NodeMapper();
                Config config = mapper.deserialize((Node)configuration, Config.class);
                return new EmitNoneSelectorValidator(config);
            });
        }
    }
}

