/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collection;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.shapes.Shape;

interface InternalSelector {
    public static final InternalSelector IDENTITY = (ctx, shape, next) -> next.apply(ctx, shape);

    public Response push(Context var1, Shape var2, Receiver var3);

    default public <C extends Collection<Shape>> C pushResultsToCollection(Context context, Shape shape, C captures) {
        this.push(context, shape, (c, s) -> {
            captures.add(s);
            return Response.CONTINUE;
        });
        return captures;
    }

    default public Collection<? extends Shape> getStartingShapes(Model model) {
        return model.toSet();
    }

    default public ContainsShape containsShapeOptimization(Context context, Shape shape) {
        return ContainsShape.MAYBE;
    }

    public static interface Receiver {
        public Response apply(Context var1, Shape var2);
    }

    public static enum Response {
        CONTINUE,
        STOP;

    }

    public static enum ContainsShape {
        YES,
        NO,
        MAYBE;

    }
}

