/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.ProtocolDefinitionTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class NoInlineDocumentSupportValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        Set documents = model.shapes(DocumentShape.class).collect(Collectors.toSet());
        if (documents.isEmpty()) {
            return Collections.emptyList();
        }
        Set<ShapeId> noInlineDocumentSupport = this.findProtocolsWithNoInlineDocumentSupport(model);
        if (noInlineDocumentSupport.isEmpty()) {
            return Collections.emptyList();
        }
        List services = model.shapes(ServiceShape.class).collect(Collectors.toList());
        Walker walker = new Walker(model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape service : services) {
            for (ShapeId protocol : noInlineDocumentSupport) {
                if (!service.findTrait(protocol).isPresent()) continue;
                Set<Shape> shapes = walker.walkShapes(service);
                TreeSet<Shape> foundDocuments = new TreeSet<Shape>();
                for (DocumentShape documentShape : documents) {
                    if (!shapes.contains(documentShape)) continue;
                    foundDocuments.add(documentShape);
                }
                if (foundDocuments.isEmpty()) continue;
                events.add(this.createEvent(service, service.findTrait(protocol).get(), foundDocuments));
            }
        }
        return events;
    }

    private Set<ShapeId> findProtocolsWithNoInlineDocumentSupport(Model model) {
        HashSet<ShapeId> noInlineDocumentSupport = new HashSet<ShapeId>();
        for (Shape shape : model.getShapesWithTrait(ProtocolDefinitionTrait.class)) {
            ProtocolDefinitionTrait definitionTrait = shape.expectTrait(ProtocolDefinitionTrait.class);
            if (!definitionTrait.getNoInlineDocumentSupport()) continue;
            noInlineDocumentSupport.add(shape.getId());
        }
        return noInlineDocumentSupport;
    }

    private ValidationEvent createEvent(ServiceShape service, Trait protocol, Set<Shape> foundDocuments) {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (Shape document : foundDocuments) {
            joiner.add(document.getId() + " @ " + document.getSourceLocation());
        }
        return this.error((Shape)service, protocol, String.format("This service uses the `%s` protocol which does not support inline document types, but the following document types were found in the closure of the service: %s", protocol.toShapeId(), joiner.toString()));
    }
}

