/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.IdlToken;
import software.amazon.smithy.model.loader.IdlTokenizer;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class LoaderUtils {
    static final String BAD_DOCUMENTATION_COMMENT = "Model.BadDocumentationComment";

    private LoaderUtils() {
    }

    static Optional<ValidationEvent> checkForAdditionalProperties(ObjectNode node, ShapeId shape, Collection<String> properties) {
        try {
            node.expectNoAdditionalProperties(properties);
            return Optional.empty();
        }
        catch (ExpectationNotMetException e) {
            ValidationEvent event = ValidationEvent.fromSourceException(e).toBuilder().shapeId(shape).severity(Severity.WARNING).build();
            return Optional.of(event);
        }
    }

    static ValidationEvent onShapeConflict(ShapeId id, SourceLocation a, SourceLocation b, String message) {
        String formatted = String.format("Conflicting shape definition for `%s` found at `%s` and `%s`", id, a, b);
        if (message != null) {
            formatted = formatted + ". " + message;
        }
        return ValidationEvent.builder().id("Model").severity(Severity.ERROR).sourceLocation(b).shapeId(id).message(formatted).build();
    }

    static boolean isSameLocation(FromSourceLocation a, FromSourceLocation b) {
        SourceLocation sa = a.getSourceLocation();
        SourceLocation sb = b.getSourceLocation();
        return sa != SourceLocation.NONE && sa.equals(sb);
    }

    static boolean containsErrorEvents(List<ValidationEvent> events) {
        for (ValidationEvent event : events) {
            if (event.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    static ValidationEvent emitBadDocComment(SourceLocation location, String comments) {
        String message = "Found documentation comments ('///') attached to nothing. Documentation comments must appear on their own lines, directly before shapes and members, and before any traits.";
        if (comments != null) {
            message = message + " The invalid comments were: " + comments;
        }
        return ValidationEvent.builder().id(BAD_DOCUMENTATION_COMMENT).severity(Severity.WARNING).message(message).sourceLocation(location).build();
    }

    static String idlExpectMessage(IdlTokenizer tokenizer, IdlToken ... tokens) {
        StringBuilder result = new StringBuilder();
        IdlToken current = tokenizer.getCurrentToken();
        if (current == IdlToken.ERROR) {
            result.append(tokenizer.getCurrentTokenError());
        } else if (tokens.length == 1) {
            result.append("Expected ").append(tokens[0].getDebug()).append(" but found ").append(current.getDebug(tokenizer.getCurrentTokenLexeme()));
        } else {
            result.append("Expected one of ");
            for (IdlToken token : tokens) {
                result.append(token.getDebug()).append(", ");
            }
            result.delete(result.length() - 2, result.length());
            result.append("; but found ").append(current.getDebug(tokenizer.getCurrentTokenLexeme()));
        }
        return result.toString();
    }

    static ModelSyntaxException idlSyntaxError(String message, SourceLocation location) {
        return LoaderUtils.idlSyntaxError(null, message, location);
    }

    static ModelSyntaxException idlSyntaxError(ShapeId shape, String message, SourceLocation location) {
        return ModelSyntaxException.builder().message(String.format("Syntax error at line %d, column %d: %s", location.getLine(), location.getColumn(), message)).sourceLocation(location).shapeId(shape).build();
    }
}

