/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.pattern.UriPattern;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.PatternTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public final class HttpUriConflictValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        if (!model.isTraitApplied(HttpTrait.class)) {
            return Collections.emptyList();
        }
        return model.shapes(ServiceShape.class).flatMap(shape -> this.validateService(model, (ServiceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(Model model, ServiceShape service) {
        List operations = TopDownIndex.of(model).getContainedOperations(service).stream().filter(shape -> shape.getTrait(HttpTrait.class).isPresent()).collect(Collectors.toList());
        return operations.stream().flatMap(shape -> Trait.flatMapStream(shape, HttpTrait.class)).flatMap(pair -> this.checkConflicts(model, (Pair<OperationShape, HttpTrait>)pair, operations).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> checkConflicts(Model model, Pair<OperationShape, HttpTrait> pair, List<OperationShape> operations) {
        OperationShape operation = (OperationShape)pair.getLeft();
        String method = ((HttpTrait)pair.getRight()).getMethod();
        UriPattern pattern = ((HttpTrait)pair.getRight()).getUri();
        ArrayList<Pair<ShapeId, UriPattern>> conflicts = new ArrayList<Pair<ShapeId, UriPattern>>();
        ArrayList<Pair<ShapeId, UriPattern>> allowableConflicts = new ArrayList<Pair<ShapeId, UriPattern>>();
        operations.stream().filter(shape -> shape != operation).flatMap(shape -> Trait.flatMapStream(shape, HttpTrait.class)).filter(other -> ((HttpTrait)other.getRight()).getMethod().equals(method)).filter(other -> ((HttpTrait)other.getRight()).getUri().conflictsWith(pattern)).forEach(other -> {
            if (this.isAllowableConflict(model, operation, (OperationShape)other.getLeft())) {
                allowableConflicts.add(Pair.of((Object)((OperationShape)other.getLeft()).getId(), (Object)((HttpTrait)other.getRight()).getUri()));
            } else {
                conflicts.add(Pair.of((Object)((OperationShape)other.getLeft()).getId(), (Object)((HttpTrait)other.getRight()).getUri()));
            }
        });
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (!conflicts.isEmpty()) {
            events.add(this.error(operation, this.formatConflicts(pattern, conflicts)));
        }
        if (!allowableConflicts.isEmpty()) {
            String message = this.formatConflicts(pattern, allowableConflicts) + ". Pattern traits applied to the label members prevent the label value from evaluating to a conflict, but this is still a poor design. If this is acceptable, this can be suppressed.";
            events.add(this.danger(operation, message));
        }
        return events;
    }

    private boolean isAllowableConflict(Model model, OperationShape operation, OperationShape otherOperation) {
        UriPattern otherUriPattern;
        UriPattern uriPattern = operation.getTrait(HttpTrait.class).get().getUri();
        List<Pair<SmithyPattern.Segment, SmithyPattern.Segment>> conflictingLabelSegments = uriPattern.getConflictingLabelSegments(otherUriPattern = otherOperation.getTrait(HttpTrait.class).get().getUri());
        if (conflictingLabelSegments.isEmpty()) {
            return false;
        }
        Map<String, Pattern> labelPatterns = this.getLabelPatterns(model, operation);
        Map<String, Pattern> otherLabelPatterns = this.getLabelPatterns(model, otherOperation);
        return conflictingLabelSegments.stream().filter(conflict -> ((SmithyPattern.Segment)conflict.getLeft()).isLabel() != ((SmithyPattern.Segment)conflict.getRight()).isLabel()).allMatch(conflict -> {
            String staticSegment;
            Pattern pattern;
            if (((SmithyPattern.Segment)conflict.getLeft()).isLabel()) {
                pattern = (Pattern)labelPatterns.get(((SmithyPattern.Segment)conflict.getLeft()).getContent());
                staticSegment = ((SmithyPattern.Segment)conflict.getRight()).getContent();
            } else {
                pattern = (Pattern)otherLabelPatterns.get(((SmithyPattern.Segment)conflict.getRight()).getContent());
                staticSegment = ((SmithyPattern.Segment)conflict.getLeft()).getContent();
            }
            if (pattern == null) {
                return false;
            }
            return !pattern.matcher(staticSegment).find();
        });
    }

    private Map<String, Pattern> getLabelPatterns(Model model, OperationShape operation) {
        return HttpBindingIndex.of(model).getRequestBindings(operation).entrySet().stream().filter(entry -> ((HttpBinding)entry.getValue()).getLocation().equals((Object)HttpBinding.Location.LABEL)).flatMap(entry -> OptionalUtils.stream(((HttpBinding)entry.getValue()).getMember().getMemberTrait(model, PatternTrait.class).map(pattern -> Pair.of((Object)((String)entry.getKey()), (Object)pattern.getPattern())))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private String formatConflicts(UriPattern pattern, List<Pair<ShapeId, UriPattern>> conflicts) {
        String conflictString = conflicts.stream().map(conflict -> String.format("`%s` (%s)", conflict.getLeft(), conflict.getRight())).sorted().collect(Collectors.joining(", "));
        return String.format("Operation URI, `%s`, conflicts with other operation URIs in the same service: [%s]", pattern, conflictString);
    }
}

