/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.IdentifierBindingIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.PropertyBindingIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ResourceOperationInputOutputValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        LinkedList<ValidationEvent> events = new LinkedList<ValidationEvent>();
        for (ResourceShape resourceShape : model.getResourceShapes()) {
            if (!resourceShape.hasProperties()) continue;
            events.addAll(this.validateResource(model, resourceShape));
        }
        return events;
    }

    private List<ValidationEvent> validateResource(Model model, ResourceShape resource) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        TreeSet<String> propertiesInOperations = new TreeSet<String>();
        OperationIndex operationIndex = OperationIndex.of(model);
        PropertyBindingIndex propertyBindingIndex = PropertyBindingIndex.of(model);
        this.processLifecycleOperationProperties(model, resource, "put", resource.getPut(), operationIndex, propertyBindingIndex, propertiesInOperations, events);
        this.processLifecycleOperationProperties(model, resource, "create", resource.getCreate(), operationIndex, propertyBindingIndex, propertiesInOperations, events);
        this.processLifecycleOperationProperties(model, resource, "read", resource.getRead(), operationIndex, propertyBindingIndex, propertiesInOperations, events);
        this.processLifecycleOperationProperties(model, resource, "update", resource.getUpdate(), operationIndex, propertyBindingIndex, propertiesInOperations, events);
        this.processLifecycleOperationProperties(model, resource, "delete", resource.getDelete(), operationIndex, propertyBindingIndex, propertiesInOperations, events);
        for (ShapeId operationId : resource.getOperations()) {
            this.processLifecycleOperationProperties(model, resource, operationId.getName(), Optional.of(operationId), operationIndex, propertyBindingIndex, propertiesInOperations, events);
        }
        HashSet<String> definedProperties = new HashSet<String>(resource.getProperties().keySet());
        definedProperties.removeAll(propertiesInOperations);
        for (String propertyNotInLifecycleOp : definedProperties) {
            events.add(this.error(resource, String.format("Resource property `%s` is not used in the input or output of create or an instance operation.", propertyNotInLifecycleOp)));
        }
        return events;
    }

    private void processLifecycleOperationProperties(Model model, ResourceShape resource, String name, Optional<ShapeId> operationShapeId, OperationIndex operationIndex, PropertyBindingIndex propertyBindingIndex, Set<String> propertiesInOperations, List<ValidationEvent> events) {
        operationShapeId.flatMap(model::getShape).flatMap(Shape::asOperationShape).ifPresent(operation -> {
            propertiesInOperations.addAll(this.getAllOperationProperties(propertyBindingIndex, (OperationShape)operation));
            this.validateOperationInputOutput(model, propertyBindingIndex, operationIndex, resource, (OperationShape)operation, name, events);
        });
    }

    private List<String> getAllOperationProperties(PropertyBindingIndex propertyBindingIndex, OperationShape operation) {
        ArrayList<String> properties = new ArrayList<String>();
        for (MemberShape member : propertyBindingIndex.getInputPropertiesShape(operation).members()) {
            if (!propertyBindingIndex.isMemberShapeProperty(member)) continue;
            properties.add(propertyBindingIndex.getPropertyName(member.getId()).get());
        }
        for (MemberShape member : propertyBindingIndex.getOutputPropertiesShape(operation).members()) {
            if (!propertyBindingIndex.isMemberShapeProperty(member)) continue;
            properties.add(propertyBindingIndex.getPropertyName(member.getId()).get());
        }
        return properties;
    }

    private void validateOperationInputOutput(Model model, PropertyBindingIndex propertyBindingIndex, OperationIndex operationIndex, ResourceShape resource, OperationShape operation, String lifecycleOperationName, List<ValidationEvent> events) {
        this.validateOperationInput(model, propertyBindingIndex, operationIndex, resource, operation, lifecycleOperationName, events);
        this.validateOperationOutput(model, propertyBindingIndex, operationIndex, resource, operation, lifecycleOperationName, events);
    }

    private void validateOperationOutput(Model model, PropertyBindingIndex propertyBindingIndex, OperationIndex operationIndex, ResourceShape resource, OperationShape operation, String lifecycleOperationName, List<ValidationEvent> events) {
        Map<String, ShapeId> properties = resource.getProperties();
        TreeMap<String, Set<MemberShape>> propertyToMemberMappings = new TreeMap<String, Set<MemberShape>>();
        IdentifierBindingIndex identifierBindingIndex = IdentifierBindingIndex.of(model);
        HashSet<String> identifierMembers = new HashSet<String>(identifierBindingIndex.getOperationOutputBindings(resource, operation).values());
        StructureShape shape = propertyBindingIndex.getOutputPropertiesShape(operation);
        for (MemberShape member : shape.members()) {
            if (!propertyBindingIndex.isMemberShapeProperty(member)) continue;
            this.validateMember(events, lifecycleOperationName, propertyBindingIndex, resource, member, identifierMembers, properties, propertyToMemberMappings);
        }
        this.validateConflictingProperties(events, shape, propertyToMemberMappings);
    }

    private void validateOperationInput(Model model, PropertyBindingIndex propertyBindingIndex, OperationIndex operationIndex, ResourceShape resource, OperationShape operation, String lifecycleOperationName, List<ValidationEvent> events) {
        Map<String, ShapeId> properties = resource.getProperties();
        TreeMap<String, Set<MemberShape>> propertyToMemberMappings = new TreeMap<String, Set<MemberShape>>();
        IdentifierBindingIndex identifierBindingIndex = IdentifierBindingIndex.of(model);
        HashSet<String> identifierMembers = new HashSet<String>(identifierBindingIndex.getOperationOutputBindings(resource, operation).values());
        StructureShape shape = propertyBindingIndex.getInputPropertiesShape(operation);
        for (MemberShape member : shape.members()) {
            if (!propertyBindingIndex.isMemberShapeProperty(member)) continue;
            this.validateMember(events, lifecycleOperationName, propertyBindingIndex, resource, member, identifierMembers, properties, propertyToMemberMappings);
        }
        this.validateConflictingProperties(events, shape, propertyToMemberMappings);
    }

    private void validateConflictingProperties(List<ValidationEvent> events, Shape shape, Map<String, Set<MemberShape>> propertyToMemberMappings) {
        for (Map.Entry<String, Set<MemberShape>> entry : propertyToMemberMappings.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            events.add(this.error(shape, String.format("This shape contains members with conflicting property names that resolve to '%s': %s", entry.getKey(), entry.getValue().stream().map(MemberShape::getMemberName).collect(Collectors.joining(", ")))));
        }
    }

    private void validateMember(List<ValidationEvent> events, String lifecycleOperationName, PropertyBindingIndex propertyBindingIndex, ResourceShape resource, MemberShape member, Set<String> identifierMembers, Map<String, ShapeId> properties, Map<String, Set<MemberShape>> propertyToMemberMappings) {
        String propertyName = propertyBindingIndex.getPropertyName(member.getId()).get();
        propertyToMemberMappings.computeIfAbsent(propertyName, m -> new TreeSet()).add(member);
        if (properties.containsKey(propertyName)) {
            if (!properties.get(propertyName).equals(member.getTarget())) {
                events.add(this.error(resource, String.format("The resource property `%s` has a conflicting target shape `%s` on the `%s` operation which targets `%s`.", propertyName, member.getTarget().toString(), lifecycleOperationName, properties.get(propertyName).toString())));
            }
        } else if (!identifierMembers.contains(member.getMemberName())) {
            events.add(this.error(member, String.format("Member `%s` does not target a property or identifier for resource `%s`", member.getMemberName(), resource.getId().toString())));
        }
    }
}

