/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MixinTrait
extends AbstractTrait
implements ToSmithyBuilder<MixinTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#mixin");
    private final Set<ShapeId> localTraits;

    private MixinTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.localTraits = SetUtils.orderedCopyOf((Collection)builder.localTraits);
    }

    public Set<ShapeId> getLocalTraits() {
        return this.localTraits;
    }

    @Override
    protected Node createNode() {
        if (this.localTraits.size() <= 1) {
            return Node.objectNode();
        }
        ArrayList<StringNode> nonImplicitValues = new ArrayList<StringNode>();
        for (ShapeId trait : this.localTraits) {
            if (trait.equals(ID)) continue;
            nonImplicitValues.add(Node.from(trait.toString()));
        }
        return Node.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withMember("localTraits", Node.fromNodes(nonImplicitValues)).build();
    }

    public Builder toBuilder() {
        return ((Builder)MixinTrait.builder().sourceLocation(this.getSourceLocation())).localTraits(this.localTraits);
    }

    public static Map<ShapeId, Trait> getNonLocalTraitsFromMap(Map<ShapeId, Trait> traits) {
        if (traits.isEmpty() || !traits.containsKey(ID)) {
            return traits;
        }
        HashMap<ShapeId, Trait> filtered = new HashMap<ShapeId, Trait>(traits);
        MixinTrait mixinTrait = (MixinTrait)traits.get(ID);
        for (ShapeId toRemove : mixinTrait.getLocalTraits()) {
            filtered.remove(toRemove);
        }
        return filtered;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public MixinTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)MixinTrait.builder().sourceLocation(value);
            value.expectObjectNode().getArrayMember("localTraits", ShapeId::fromNode, builder::localTraits);
            return builder.build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<MixinTrait, Builder> {
        private final Set<ShapeId> localTraits = new LinkedHashSet<ShapeId>();

        public MixinTrait build() {
            this.localTraits.add(ID);
            return new MixinTrait(this);
        }

        public Builder localTraits(Collection<ShapeId> traits) {
            this.localTraits.clear();
            this.localTraits.addAll(traits);
            return this;
        }

        public Builder addLocalTrait(ShapeId trait) {
            this.localTraits.add(trait);
            return this;
        }
    }
}

