/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.testrunner;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.validation.testrunner.SmithyTestCase;

public final class SmithyTestSuite {
    private static final String DEFAULT_TEST_CASE_LOCATION = "errorfiles";
    private final List<SmithyTestCase> cases = new ArrayList<SmithyTestCase>();
    private Supplier<ModelAssembler> modelAssemblerFactory = ModelAssembler::new;

    private SmithyTestSuite() {
    }

    public static SmithyTestSuite runner() {
        return new SmithyTestSuite();
    }

    public static Stream<Object[]> defaultParameterizedTestSource(Class<?> contextClass) {
        ClassLoader classLoader = contextClass.getClassLoader();
        ModelAssembler assembler = Model.assembler(classLoader).discoverModels(classLoader);
        return SmithyTestSuite.runner().setModelAssemblerFactory(assembler::copy).addTestCasesFromUrl(contextClass.getResource(DEFAULT_TEST_CASE_LOCATION)).parameterizedTestSource();
    }

    private Stream<Object[]> parameterizedTestSource() {
        return this.cases.stream().map(testCase -> {
            Callable<SmithyTestCase.Result> callable = this.createTestCaseCallable((SmithyTestCase)testCase);
            Callable<SmithyTestCase.Result> wrappedCallable = () -> ((SmithyTestCase.Result)callable.call()).unwrap();
            return new Object[]{testCase.getModelLocation(), wrappedCallable};
        });
    }

    public SmithyTestSuite addTestCase(SmithyTestCase testCase) {
        this.cases.add(testCase);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SmithyTestSuite addTestCasesFromDirectory(Path modelDirectory) {
        try (Stream<Path> files = Files.walk(modelDirectory, new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> {
                String filename = file.toString();
                return filename.endsWith(".json") || filename.endsWith(".smithy");
            }).map(file -> SmithyTestCase.fromModelFile(file.toString())).forEach(this::addTestCase);
            SmithyTestSuite smithyTestSuite = this;
            return smithyTestSuite;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SmithyTestSuite addTestCasesFromUrl(URL url) {
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Only file URLs are supported by the testrunner: " + url);
        }
        try {
            return this.addTestCasesFromDirectory(Paths.get(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public SmithyTestSuite setModelAssemblerFactory(Supplier<ModelAssembler> modelAssemblerFactory) {
        this.modelAssemblerFactory = Objects.requireNonNull(modelAssemblerFactory);
        return this;
    }

    public Stream<Callable<SmithyTestCase.Result>> testCaseCallables() {
        return this.cases.stream().map(this::createTestCaseCallable);
    }

    private Callable<SmithyTestCase.Result> createTestCaseCallable(SmithyTestCase testCase) {
        return () -> {
            ModelAssembler assembler = this.modelAssemblerFactory.get();
            assembler.addImport(testCase.getModelLocation());
            return testCase.createResult(assembler.assemble());
        };
    }

    public Result run() {
        return this.run(ForkJoinPool.commonPool());
    }

    public Result run(ExecutorService executorService) {
        List<SmithyTestCase.Result> failedResults = Collections.synchronizedList(new ArrayList());
        List callables = this.testCaseCallables().collect(Collectors.toList());
        try {
            for (Future<SmithyTestCase.Result> result2 : executorService.invokeAll(callables)) {
                SmithyTestCase.Result testCaseResult = this.waitOnFuture(result2);
                if (!testCaseResult.isInvalid()) continue;
                failedResults.add(testCaseResult);
            }
            Result result = new Result(callables.size() - failedResults.size(), failedResults);
            if (failedResults.isEmpty()) {
                Result result2 = result;
                return result2;
            }
            try {
                throw new Error(result);
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
                throw new Error("Error executing test suite: " + e.getMessage(), e);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private SmithyTestCase.Result waitOnFuture(Future<SmithyTestCase.Result> future) throws InterruptedException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new Error("Error executing test case: " + e.getMessage(), cause);
        }
    }

    public static final class Error
    extends RuntimeException {
        public final Result result;

        Error(Result result) {
            super(result.toString());
            this.result = result;
        }

        Error(String message, Throwable previous) {
            super(message, previous);
            this.result = new Result(0, Collections.emptyList());
        }
    }

    public static final class Result {
        private final int successCount;
        private final List<SmithyTestCase.Result> failedResults;

        Result(int successCount, List<SmithyTestCase.Result> failedResults) {
            this.successCount = successCount;
            this.failedResults = Collections.unmodifiableList(failedResults);
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public List<SmithyTestCase.Result> getFailedResults() {
            return this.failedResults;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("Smithy validation test runner encountered %d successful result(s), and %d failed result(s)", this.getSuccessCount(), this.getFailedResults().size()));
            this.getFailedResults().forEach(failed -> builder.append('\n').append(failed.toString()).append('\n'));
            return builder.toString();
        }
    }
}

