/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.transform.ModelTransformException;
import software.amazon.smithy.model.transform.ModelTransformer;

final class MapShapes {
    private final Function<Shape, Shape> mapper;

    MapShapes(Function<Shape, Shape> mapper) {
        this.mapper = mapper;
    }

    Model transform(ModelTransformer transformer, Model model) {
        return transformer.replaceShapes(model, model.shapes().flatMap(shape -> {
            Shape mapped = Objects.requireNonNull(this.mapper.apply((Shape)shape), "Shape mapper must not return null");
            if (mapped.equals(shape)) {
                return Stream.empty();
            }
            if (!mapped.getId().equals(shape.getId())) {
                throw new ModelTransformException(String.format("Mapped shapes must have the same shape ID. Expected %s, but found %s", shape.getId(), mapped.getId()));
            }
            return Stream.of(mapped);
        }).collect(Collectors.toSet()));
    }
}

