/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Objects;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class RetryableTrait
extends AbstractTrait
implements ToSmithyBuilder<RetryableTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#retryable");
    private final boolean throttling;

    private RetryableTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
        this.throttling = builder.throttling;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean getThrottling() {
        return this.throttling;
    }

    public Builder toBuilder() {
        return ((Builder)RetryableTrait.builder().sourceLocation(this.getSourceLocation())).throttling(this.throttling);
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder nodeBuilder = Node.objectNodeBuilder().sourceLocation(this.getSourceLocation());
        if (this.throttling) {
            nodeBuilder.withMember("throttling", true);
        }
        return nodeBuilder.build();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RetryableTrait)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        RetryableTrait ot = (RetryableTrait)other;
        return this.throttling == ot.throttling;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.toShapeId(), this.throttling);
    }

    public static final class Builder
    extends AbstractTraitBuilder<RetryableTrait, Builder> {
        private boolean throttling;

        private Builder() {
        }

        public RetryableTrait build() {
            return new RetryableTrait(this);
        }

        public Builder throttling(boolean throttling) {
            this.throttling = throttling;
            return this;
        }
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public RetryableTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)RetryableTrait.builder().sourceLocation(value.getSourceLocation());
            value.expectObjectNode().getBooleanMember("throttling", builder::throttling);
            RetryableTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

