/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.BuilderRef;

final class NamedMemberUtils {
    private NamedMemberUtils() {
    }

    static Map<String, MemberShape> computeMixinMembers(Map<ShapeId, Shape> mixins, BuilderRef<Map<String, MemberShape>> members, ShapeId shapeId, SourceLocation sourceLocation) {
        if (mixins.isEmpty()) {
            return (Map)members.copy();
        }
        LinkedHashMap<String, MemberShape> computedMembers = new LinkedHashMap<String, MemberShape>();
        for (Shape shape : mixins.values()) {
            for (MemberShape member : shape.members()) {
                String name = member.getMemberName();
                if (((Map)members.get()).containsKey(name)) {
                    MemberShape localMember = (MemberShape)((Map)members.get()).get(name);
                    if (localMember.getMixins().isEmpty() || !mixins.containsKey(member.getId())) {
                        localMember = ((MemberShape.Builder)((MemberShape.Builder)localMember.toBuilder().clearMixins()).addMixin(member)).build();
                    }
                    computedMembers.put(name, localMember);
                    continue;
                }
                computedMembers.put(name, ((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(shapeId.withMember(name))).target(member.getTarget()).source(sourceLocation)).addMixin(member)).build());
            }
        }
        for (MemberShape member : ((Map)members.get()).values()) {
            if (computedMembers.containsKey(member.getMemberName())) continue;
            computedMembers.put(member.getMemberName(), member);
        }
        return Collections.unmodifiableMap(computedMembers);
    }

    static Set<MemberShape> flattenMixins(Map<String, MemberShape> members, Map<ShapeId, Shape> mixins, ShapeId shapeId, SourceLocation sourceLocation) {
        LinkedHashSet<MemberShape> orderedMembers = new LinkedHashSet<MemberShape>();
        for (Shape mixin : mixins.values()) {
            for (MemberShape member : mixin.members()) {
                SourceLocation location = sourceLocation;
                Collection<Object> localTraits = Collections.emptyList();
                MemberShape existing = members.remove(member.getMemberName());
                if (existing != null) {
                    localTraits = existing.getIntroducedTraits().values();
                    location = existing.getSourceLocation();
                }
                orderedMembers.add(((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(shapeId.withMember(member.getMemberName()))).target(member.getTarget()).addTraits(member.getAllTraits().values())).addTraits(localTraits)).source(location)).build());
            }
        }
        orderedMembers.addAll(members.values());
        return orderedMembers;
    }

    static void cleanMixins(Shape newMixin, Map<String, MemberShape> members) {
        members.values().removeIf(member -> {
            if (!NamedMemberUtils.isMemberMixedInFromShape(newMixin.getId(), member)) {
                return false;
            }
            for (MemberShape mixinMember : newMixin.members()) {
                if (!mixinMember.getMemberName().equals(member.getMemberName())) continue;
                return false;
            }
            return true;
        });
    }

    static void removeMixin(ToShapeId mixin, Map<String, MemberShape> members) {
        ShapeId id = mixin.toShapeId();
        members.values().removeIf(member -> NamedMemberUtils.isMemberMixedInFromShape(id, member));
    }

    private static boolean isMemberMixedInFromShape(ShapeId check, MemberShape member) {
        if (member.getMixins().contains(check)) {
            return true;
        }
        for (ShapeId memberMixin : member.getMixins()) {
            if (!memberMixin.withoutMember().equals(check)) continue;
            return true;
        }
        return false;
    }
}

