/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;

public final class ServiceValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape shape : model.getServiceShapes()) {
            this.validateService(model, shape, events);
        }
        return events;
    }

    private void validateService(Model model, ServiceShape service, List<ValidationEvent> events) {
        Walker walker = new Walker(NeighborProviderIndex.of(model).getProvider());
        HashMap<ShapeId, Shape> serviceClosure = new HashMap<ShapeId, Shape>();
        walker.iterateShapes(service).forEachRemaining(shape -> serviceClosure.put(shape.getId(), (Shape)shape));
        HashMap<String, Set> normalizedNamesToIds = new HashMap<String, Set>();
        for (ShapeId id : serviceClosure.keySet()) {
            if (id.getMember().isPresent()) continue;
            String possiblyRename = service.getContextualName(id);
            normalizedNamesToIds.computeIfAbsent(possiblyRename.toLowerCase(Locale.ENGLISH), name -> new TreeSet()).add(id);
        }
        ConflictDetector detector = new ConflictDetector(model);
        for (Map.Entry entry : normalizedNamesToIds.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (ids.size() <= 1) continue;
            for (ShapeId subjectId : ids) {
                model.getShape(subjectId).ifPresent(subject -> {
                    for (ShapeId otherId : ids) {
                        if (otherId.equals(subjectId)) continue;
                        model.getShape(otherId).ifPresent(other -> {
                            Severity severity = detector.detect((Shape)subject, (Shape)other);
                            if (severity != null) {
                                events.add(this.conflictingNames(severity, service, (Shape)subject, (Shape)other));
                            }
                        });
                    }
                });
            }
        }
        events.addAll(this.validateRenames(service, serviceClosure));
    }

    private List<ValidationEvent> validateRenames(ServiceShape service, Map<ShapeId, Shape> closure) {
        if (service.getRename().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        HashMap<String, Set> renameMappings = new HashMap<String, Set>();
        for (Map.Entry<ShapeId, String> rename : service.getRename().entrySet()) {
            ShapeId from = rename.getKey();
            String to = rename.getValue();
            renameMappings.computeIfAbsent(to.toLowerCase(Locale.ENGLISH), t -> new HashSet()).add(from);
            if (!ShapeId.isValidIdentifier(to)) {
                events.add(this.error(service, String.format("Service attempts to rename `%s` to an invalid identifier, \"%s\"", from, to)));
            } else if (to.equals(from.getName())) {
                events.add(this.error(service, String.format("Service rename for `%s` does not actually change the name from `%s`", from, to)));
            }
            if (!closure.containsKey(from)) {
                events.add(this.error(service, "Service attempts to rename a shape not in the service: " + from));
                continue;
            }
            this.getInvalidRenameReason(closure.get(from)).ifPresent(reason -> events.add(this.error(service, String.format("Service attempts to rename a %s shape from `%s` to \"%s\"; %s", new Object[]{((Shape)closure.get(from)).getType(), from, to, reason}))));
        }
        return events;
    }

    private Optional<String> getInvalidRenameReason(Shape shape) {
        if (shape.isMemberShape() || shape.isResourceShape() || shape.isOperationShape()) {
            return Optional.of((Object)((Object)shape.getType()) + "s cannot be renamed");
        }
        if (shape.hasTrait(ErrorTrait.class)) {
            return Optional.of("errors cannot be renamed");
        }
        return Optional.empty();
    }

    private ValidationEvent conflictingNames(Severity severity, ServiceShape service, Shape subject, Shape other) {
        StringBuilder message = new StringBuilder();
        if (service.getRename().get(subject.getId()) != null) {
            message.append("Renamed shape name \"").append(service.getRename().get(subject.getId())).append('\"');
        } else {
            message.append("Shape name `").append(subject.getId()).append('`');
        }
        message.append(" conflicts with `").append(other.getId()).append("` ");
        if (service.getRename().get(other.getId()) != null) {
            message.append("(renamed to \"").append(service.getRename().get(other.getId())).append("\") ");
        }
        message.append("in the `").append(service.getId()).append("` service closure. ").append("Shapes in the closure of a service ").append(severity.ordinal() >= Severity.DANGER.ordinal() ? "must " : "should ").append("have case-insensitively unique names regardless of their namespaces. ").append("Use the `rename` property of the service to disambiguate shape names.");
        return ValidationEvent.builder().id(this.getName()).severity(severity).shape(subject).message(message.toString()).build();
    }

    private static final class ConflictDetector {
        private final Model model;
        private final Map<Pair<ShapeId, ShapeId>, Severity> cache = new HashMap<Pair<ShapeId, ShapeId>, Severity>();

        ConflictDetector(Model model) {
            this.model = model;
        }

        Severity detect(Shape a, Shape b) {
            Pair cacheKey;
            if (a == null || b == null) {
                return null;
            }
            Pair pair = cacheKey = a.getId().compareTo(b.getId()) < 0 ? Pair.of((Object)a.getId(), (Object)b.getId()) : Pair.of((Object)b.getId(), (Object)a.getId());
            if (this.cache.containsKey(cacheKey)) {
                return this.cache.get(cacheKey);
            }
            Severity result = this.detectConflicts(a, b);
            this.cache.put((Pair<ShapeId, ShapeId>)cacheKey, result);
            return result;
        }

        private Severity detectConflicts(Shape a, Shape b) {
            if (this.isShapeTypeConflictForbidden(a) || this.isShapeTypeConflictForbidden(b) || a.getType() != b.getType() || !this.equivalentTraits(a.getAllTraits(), b.getAllTraits())) {
                return Severity.ERROR;
            }
            Severity memberConflict = this.detectMemberConflicts(a, b);
            if (memberConflict != null && memberConflict.ordinal() >= Severity.WARNING.ordinal()) {
                return memberConflict;
            }
            if (a instanceof SimpleShape) {
                return Severity.NOTE;
            }
            return Severity.WARNING;
        }

        private boolean equivalentTraits(Map<ShapeId, Trait> left, Map<ShapeId, Trait> right) {
            for (Map.Entry<ShapeId, Trait> entry : left.entrySet()) {
                if (entry.getValue().isSynthetic() || Objects.equals(entry.getValue(), right.get(entry.getKey()))) continue;
                return false;
            }
            for (Map.Entry<ShapeId, Trait> entry : right.entrySet()) {
                if (entry.getValue().isSynthetic() || left.containsKey(entry.getKey())) continue;
                return false;
            }
            return true;
        }

        private boolean isShapeTypeConflictForbidden(Shape shape) {
            return !(shape instanceof SimpleShape) && !(shape instanceof CollectionShape) && !shape.isMemberShape();
        }

        private Severity detectMemberConflicts(Shape a, Shape b) {
            if (a instanceof MemberShape) {
                MemberShape aMember = (MemberShape)a;
                MemberShape bMember = (MemberShape)b;
                Shape aTarget = this.model.getShape(aMember.getTarget()).orElse(null);
                Shape bTarget = this.model.getShape(bMember.getTarget()).orElse(null);
                return this.detect(aTarget, bTarget);
            }
            if (a instanceof CollectionShape) {
                CollectionShape aCollection = (CollectionShape)a;
                CollectionShape bCollection = (CollectionShape)b;
                return this.detect(aCollection.getMember(), bCollection.getMember());
            }
            return null;
        }
    }
}

