/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.SetUtils;

public final class PaginatedTraitValidator
extends AbstractValidator {
    private static final Set<ShapeType> ITEM_SHAPES = SetUtils.of((Object[])new ShapeType[]{ShapeType.LIST, ShapeType.MAP});
    private static final Set<ShapeType> PAGE_SHAPES = SetUtils.of((Object)((Object)ShapeType.INTEGER));
    private static final Set<ShapeType> TOKEN_SHAPES = SetUtils.of((Object[])new ShapeType[]{ShapeType.STRING, ShapeType.MAP});
    private static final Set<ShapeType> DANGER_TOKEN_SHAPES = SetUtils.of((Object)((Object)ShapeType.MAP));
    private static final Pattern PATH_PATTERN = Pattern.compile("\\.");

    @Override
    public List<ValidationEvent> validate(Model model) {
        OperationIndex opIndex = OperationIndex.of(model);
        TopDownIndex topDown = TopDownIndex.of(model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : model.getOperationShapesWithTrait(PaginatedTrait.class)) {
            PaginatedTrait paginatedTrait = operation.expectTrait(PaginatedTrait.class);
            events.addAll(this.validateOperation(model, topDown, opIndex, operation, paginatedTrait));
        }
        return events;
    }

    private List<ValidationEvent> validateOperation(Model model, TopDownIndex topDownIndex, OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        events.addAll(this.validateMember(opIndex, model, null, operation, trait, new InputTokenValidator()));
        PageSizeValidator pageSizeValidator = new PageSizeValidator();
        events.addAll(this.validateMember(opIndex, model, null, operation, trait, pageSizeValidator));
        pageSizeValidator.getMember(model, opIndex, operation, trait).filter(MemberShape::isRequired).ifPresent(member -> events.add(this.warning(operation, trait, String.format("paginated trait `%s` member `%s` should not be required", pageSizeValidator.propertyName(), member.getMemberName()))));
        events.addAll(this.validateMember(opIndex, model, null, operation, trait, new OutputTokenValidator()));
        events.addAll(this.validateMember(opIndex, model, null, operation, trait, new ItemValidator()));
        if (events.isEmpty()) {
            model.shapes(ServiceShape.class).forEach(svc -> {
                if (topDownIndex.getContainedOperations((ToShapeId)svc).contains(operation)) {
                    PaginatedTrait merged = svc.getTrait(PaginatedTrait.class).map(trait::merge).orElse(trait);
                    events.addAll(this.validateMember(opIndex, model, (ServiceShape)svc, operation, merged, new InputTokenValidator()));
                    events.addAll(this.validateMember(opIndex, model, (ServiceShape)svc, operation, merged, new PageSizeValidator()));
                    events.addAll(this.validateMember(opIndex, model, (ServiceShape)svc, operation, merged, new OutputTokenValidator()));
                    events.addAll(this.validateMember(opIndex, model, (ServiceShape)svc, operation, merged, new ItemValidator()));
                }
            });
        }
        return events;
    }

    private List<ValidationEvent> validateMember(OperationIndex opIndex, Model model, ServiceShape service, OperationShape operation, PaginatedTrait trait, PropertyValidator validator) {
        Shape target;
        String prefix = service != null ? "When bound within the `" + service.getId() + "` service, " : "";
        String memberPath = validator.getMemberPath(opIndex, operation, trait).orElse(null);
        if (memberPath == null) {
            return service != null && validator.isRequiredToBePresent() ? Collections.singletonList(this.error(operation, trait, String.format("%spaginated trait `%s` is not configured", prefix, validator.propertyName()))) : Collections.emptyList();
        }
        if (!validator.pathsAllowed() && memberPath.contains(".")) {
            return Collections.singletonList(this.error(operation, trait, String.format("%spaginated trait `%s` does not allow path values", prefix, validator.propertyName())));
        }
        MemberShape member = validator.getMember(model, opIndex, operation, trait).orElse(null);
        if (member == null) {
            return Collections.singletonList(this.error(operation, trait, String.format("%spaginated trait `%s` targets a member `%s` that does not exist", prefix, validator.propertyName(), memberPath)));
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (validator.mustBeOptional() && member.isRequired()) {
            events.add(this.error(operation, trait, String.format("%spaginated trait `%s` member `%s` must not be required", prefix, validator.propertyName(), member.getMemberName())));
        }
        if ((target = (Shape)model.getShape(member.getTarget()).orElse(null)) != null) {
            if (!validator.validTargets().contains((Object)target.getType())) {
                events.add(this.error(operation, trait, String.format("%spaginated trait `%s` member `%s` targets a %s shape, but must target one of the following: [%s]", new Object[]{prefix, validator.propertyName(), member.getId().getName(), target.getType(), ValidationUtils.tickedList(validator.validTargets())})));
            }
            if (validator.dangerTargets().contains((Object)target.getType())) {
                TreeSet<ShapeType> preferredTargets = new TreeSet<ShapeType>(validator.validTargets());
                preferredTargets.removeAll(validator.dangerTargets());
                events.add(this.danger(operation, trait, String.format("%spaginated trait `%s` member `%s` targets a %s shape, but this is not recommended. One of [%s] SHOULD be targeted.", new Object[]{prefix, validator.propertyName(), member.getId().getName(), target.getType(), ValidationUtils.tickedList(preferredTargets)})));
            }
        }
        if (validator.pathsAllowed() && PATH_PATTERN.split(memberPath).length > 2) {
            events.add(this.warning(operation, trait, String.format("%spaginated trait `%s` contains a path with more than two parts, which can make your API cumbersome to use", prefix, validator.propertyName())));
        }
        return events;
    }

    private static final class InputTokenValidator
    extends PropertyValidator {
        private InputTokenValidator() {
        }

        @Override
        boolean mustBeOptional() {
            return true;
        }

        @Override
        boolean isRequiredToBePresent() {
            return true;
        }

        @Override
        String propertyName() {
            return "inputToken";
        }

        @Override
        Set<ShapeType> validTargets() {
            return TOKEN_SHAPES;
        }

        @Override
        Set<ShapeType> dangerTargets() {
            return DANGER_TOKEN_SHAPES;
        }

        @Override
        Optional<String> getMemberPath(OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
            return trait.getInputToken();
        }

        @Override
        Optional<MemberShape> getMember(Model model, OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
            StructureShape input = opIndex.expectInputShape(operation);
            return this.getMemberPath(opIndex, operation, trait).flatMap(input::getMember);
        }
    }

    private static abstract class PropertyValidator {
        private PropertyValidator() {
        }

        abstract boolean mustBeOptional();

        abstract boolean isRequiredToBePresent();

        abstract String propertyName();

        abstract Set<ShapeType> validTargets();

        Set<ShapeType> dangerTargets() {
            return Collections.emptySet();
        }

        abstract Optional<String> getMemberPath(OperationIndex var1, OperationShape var2, PaginatedTrait var3);

        abstract Optional<MemberShape> getMember(Model var1, OperationIndex var2, OperationShape var3, PaginatedTrait var4);

        boolean pathsAllowed() {
            return false;
        }
    }

    private static final class PageSizeValidator
    extends PropertyValidator {
        private PageSizeValidator() {
        }

        @Override
        boolean mustBeOptional() {
            return false;
        }

        @Override
        boolean isRequiredToBePresent() {
            return false;
        }

        @Override
        String propertyName() {
            return "pageSize";
        }

        @Override
        Set<ShapeType> validTargets() {
            return PAGE_SHAPES;
        }

        @Override
        Optional<String> getMemberPath(OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
            return trait.getPageSize();
        }

        @Override
        Optional<MemberShape> getMember(Model model, OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
            StructureShape input = opIndex.expectInputShape(operation);
            return this.getMemberPath(opIndex, operation, trait).flatMap(input::getMember);
        }
    }

    private static final class OutputTokenValidator
    extends OutputPropertyValidator {
        private OutputTokenValidator() {
        }

        @Override
        boolean mustBeOptional() {
            return true;
        }

        @Override
        boolean isRequiredToBePresent() {
            return true;
        }

        @Override
        String propertyName() {
            return "outputToken";
        }

        @Override
        Set<ShapeType> validTargets() {
            return TOKEN_SHAPES;
        }

        @Override
        Set<ShapeType> dangerTargets() {
            return DANGER_TOKEN_SHAPES;
        }

        @Override
        Optional<String> getMemberPath(OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
            return trait.getOutputToken();
        }
    }

    private static final class ItemValidator
    extends OutputPropertyValidator {
        private ItemValidator() {
        }

        @Override
        boolean mustBeOptional() {
            return false;
        }

        @Override
        boolean isRequiredToBePresent() {
            return false;
        }

        @Override
        String propertyName() {
            return "items";
        }

        @Override
        Set<ShapeType> validTargets() {
            return ITEM_SHAPES;
        }

        @Override
        Optional<String> getMemberPath(OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
            return trait.getItems();
        }
    }

    private static abstract class OutputPropertyValidator
    extends PropertyValidator {
        private OutputPropertyValidator() {
        }

        @Override
        boolean pathsAllowed() {
            return true;
        }

        @Override
        Optional<MemberShape> getMember(Model model, OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
            StructureShape outputShape = opIndex.expectOutputShape(operation);
            return this.getMemberPath(opIndex, operation, trait).map(path -> PaginatedTrait.resolveFullPath(path, model, outputShape)).flatMap(memberShapes -> {
                if (memberShapes.size() == 0) {
                    return Optional.empty();
                }
                return Optional.of((MemberShape)memberShapes.get(memberShapes.size() - 1));
            });
        }
    }
}

