/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayList;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class FlattenAndRemoveMixins {
    FlattenAndRemoveMixins() {
    }

    Model transform(ModelTransformer transformer, Model model) {
        ArrayList updatedShapes = new ArrayList();
        ArrayList toRemove = new ArrayList();
        model.shapes().forEach(shape -> {
            if (shape.hasTrait(MixinTrait.class)) {
                toRemove.add(shape);
            } else if (!shape.getMixins().isEmpty()) {
                updatedShapes.add((Shape)((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).flattenMixins().build());
            }
        });
        if (!updatedShapes.isEmpty()) {
            Model.Builder builder = model.toBuilder();
            updatedShapes.forEach(builder::addShape);
            model = builder.build();
        }
        if (!toRemove.isEmpty()) {
            model = transformer.removeShapes(model, toRemove);
        }
        return model;
    }
}

