/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayList;
import java.util.logging.Logger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.OutputTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.UnitTypeTrait;
import software.amazon.smithy.model.traits.synthetic.OriginalShapeIdTrait;
import software.amazon.smithy.model.transform.ModelTransformException;
import software.amazon.smithy.model.transform.ModelTransformer;

final class CreateDedicatedInputAndOutput {
    private static final Logger LOGGER = Logger.getLogger(CreateDedicatedInputAndOutput.class.getName());
    private final String inputSuffix;
    private final String outputSuffix;

    CreateDedicatedInputAndOutput(String inputSuffix, String outputSuffix) {
        this.inputSuffix = inputSuffix;
        this.outputSuffix = outputSuffix;
    }

    Model transform(ModelTransformer transformer, Model model) {
        NeighborProvider reverse = NeighborProviderIndex.of(model).getReverseProvider();
        OperationIndex operationIndex = OperationIndex.of(model);
        ArrayList<Shape> updates = new ArrayList<Shape>();
        ArrayList<StructureShape> toRemove = new ArrayList<StructureShape>();
        for (OperationShape operation : model.getOperationShapes()) {
            StructureShape input = operationIndex.expectInputShape(operation);
            StructureShape updatedInput = this.createdUpdatedInput(model, operation, input, reverse);
            StructureShape output = operationIndex.expectOutputShape(operation);
            StructureShape updatedOutput = this.createdUpdatedOutput(model, operation, output, reverse);
            if (updatedInput.equals(input) && updatedOutput.equals(output)) continue;
            OperationShape.Builder builder = operation.toBuilder();
            if (!updatedInput.equals(input)) {
                LOGGER.fine(() -> String.format("Updating operation input of %s from %s to %s", operation.getId(), input.getId(), updatedInput.getId()));
                updates.add(updatedInput);
                builder.input(updatedInput);
                if (!input.getId().equals(updatedInput.getId()) && this.isSingularReference(reverse, input, RelationshipType.INPUT)) {
                    toRemove.add(input);
                    LOGGER.info("Removing now unused input shape " + input.getId());
                }
            }
            if (!updatedOutput.equals(output)) {
                LOGGER.fine(() -> String.format("Updating operation output of %s from %s to %s", operation.getId(), output.getId(), updatedOutput.getId()));
                updates.add(updatedOutput);
                builder.output(updatedOutput);
                if (!output.getId().equals(updatedOutput.getId()) && this.isSingularReference(reverse, output, RelationshipType.OUTPUT)) {
                    toRemove.add(output);
                    LOGGER.info("Removing now unused output shape " + output.getId());
                }
            }
            updates.add(builder.build());
        }
        Model result = transformer.replaceShapes(model, updates);
        return transformer.removeShapes(result, toRemove);
    }

    private StructureShape createdUpdatedInput(Model model, OperationShape operation, StructureShape input, NeighborProvider reverse) {
        if (input.hasTrait(InputTrait.class)) {
            return this.renameShapeIfNeeded(model, input, operation, this.inputSuffix);
        }
        if (this.isDedicatedHeuristic(operation, input, reverse, RelationshipType.INPUT)) {
            LOGGER.fine(() -> "Attaching the @input trait to " + input.getId());
            InputTrait trait = new InputTrait(input.getSourceLocation());
            return this.renameShapeIfNeeded(model, ((StructureShape.Builder)input.toBuilder().addTrait(trait)).build(), operation, this.inputSuffix);
        }
        return CreateDedicatedInputAndOutput.createSyntheticShape(model, operation, this.inputSuffix, input, new InputTrait());
    }

    private StructureShape createdUpdatedOutput(Model model, OperationShape operation, StructureShape output, NeighborProvider reverse) {
        if (output.hasTrait(OutputTrait.class)) {
            return this.renameShapeIfNeeded(model, output, operation, this.outputSuffix);
        }
        if (this.isDedicatedHeuristic(operation, output, reverse, RelationshipType.OUTPUT)) {
            LOGGER.fine(() -> "Attaching the @output trait to " + output.getId());
            OutputTrait trait = new OutputTrait(output.getSourceLocation());
            return this.renameShapeIfNeeded(model, ((StructureShape.Builder)output.toBuilder().addTrait(trait)).build(), operation, this.outputSuffix);
        }
        return CreateDedicatedInputAndOutput.createSyntheticShape(model, operation, this.outputSuffix, output, new OutputTrait());
    }

    private StructureShape renameShapeIfNeeded(Model model, StructureShape struct, OperationShape operation, String suffix) {
        ShapeId expectedName = ShapeId.fromParts(operation.getId().getNamespace(), operation.getId().getName() + suffix);
        if (struct.getId().equals(expectedName)) {
            return struct;
        }
        LOGGER.info(() -> "Renaming " + struct.getId() + " to " + expectedName);
        ShapeId newId = CreateDedicatedInputAndOutput.createSyntheticShapeId(model, operation, suffix);
        return ((StructureShape.Builder)((StructureShape.Builder)struct.toBuilder().id(newId)).addTrait(new OriginalShapeIdTrait(struct.getId()))).build();
    }

    private boolean isDedicatedHeuristic(OperationShape operation, StructureShape struct, NeighborProvider reverse, RelationshipType expected) {
        if (!struct.getId().getName().startsWith(operation.getId().getName())) {
            return false;
        }
        return this.isSingularReference(reverse, struct, expected);
    }

    private boolean isSingularReference(NeighborProvider reverse, Shape shape, RelationshipType expected) {
        int totalDirectedEdges = 0;
        for (Relationship rel : reverse.getNeighbors(shape)) {
            if (rel.getRelationshipType().getDirection() != RelationshipDirection.DIRECTED) continue;
            ++totalDirectedEdges;
            if (rel.getRelationshipType() == expected) continue;
            return false;
        }
        return totalDirectedEdges == 1;
    }

    private static StructureShape createSyntheticShape(Model model, OperationShape operation, String suffix, StructureShape source, Trait inputOutputTrait) {
        ShapeId newId = CreateDedicatedInputAndOutput.createSyntheticShapeId(model, operation, suffix);
        StructureShape.Builder builder = source.getId().equals(UnitTypeTrait.UNIT) ? StructureShape.builder() : source.toBuilder();
        builder.source(source.getSourceLocation());
        builder.id(newId);
        builder.addTrait(inputOutputTrait);
        if (!newId.equals(source.getId())) {
            builder.addTrait(new OriginalShapeIdTrait(source.getId()));
        }
        LOGGER.fine(() -> "Creating synthetic " + inputOutputTrait.toShapeId().getName() + " shape " + newId);
        return builder.build();
    }

    private static ShapeId createSyntheticShapeId(Model model, OperationShape operation, String suffix) {
        ShapeId newId = ShapeId.fromParts(operation.getId().getNamespace(), operation.getId().getName() + suffix);
        if (model.getShapeIds().contains(newId)) {
            ShapeId deconflicted = CreateDedicatedInputAndOutput.resolveConflict(newId, suffix);
            if (model.getShapeIds().contains(deconflicted)) {
                throw new ModelTransformException(String.format("Unable to generate a synthetic %s shape for the %s operation. The %s shape already exists in the model, and the conflict resolver also returned a shape ID that already exists: %s", suffix, operation.getId(), newId, deconflicted));
            }
            newId = deconflicted;
        }
        return newId;
    }

    private static ShapeId resolveConflict(ShapeId id, String suffix) {
        String updatedName = id.getName().replace(suffix, "Operation" + suffix);
        LOGGER.info(() -> "Deconflicting synthetic ID from " + id + " to use name " + updatedName);
        return ShapeId.fromParts(id.getNamespace(), updatedName);
    }
}

