/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.NamedMemberUtils;
import software.amazon.smithy.model.shapes.NamedMembers;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;

public abstract class NamedMembersShape
extends Shape
implements NamedMembers {
    private final Map<String, MemberShape> members;
    private volatile List<String> memberNames;

    NamedMembersShape(Builder<?, ?> builder) {
        super(builder, false);
        this.members = NamedMemberUtils.computeMixinMembers(builder.getMixins(), (BuilderRef<Map<String, MemberShape>>)((Builder)builder).members, this.getId(), this.getSourceLocation());
        this.validateMemberShapeIds();
    }

    @Override
    public Map<String, MemberShape> getAllMembers() {
        return this.members;
    }

    @Override
    public List<String> getMemberNames() {
        List names = this.memberNames;
        if (names == null) {
            this.memberNames = names = ListUtils.copyOf(this.members.keySet());
        }
        return names;
    }

    @Override
    public Optional<MemberShape> getMember(String name) {
        return Optional.ofNullable(this.members.get(name));
    }

    @Override
    public Collection<MemberShape> members() {
        return this.members.values();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        NamedMembersShape b = (NamedMembersShape)other;
        return this.getMemberNames().equals(b.getMemberNames()) && this.members.equals(b.members);
    }

    public static abstract class Builder<B extends Builder<B, S>, S extends NamedMembersShape>
    extends AbstractShapeBuilder<B, S> {
        private final BuilderRef<Map<String, MemberShape>> members = BuilderRef.forOrderedMap();

        @Override
        public final B id(ShapeId shapeId) {
            for (MemberShape member : ((Map)this.members.peek()).values()) {
                this.addMember(((MemberShape.Builder)member.toBuilder().id(shapeId.withMember(member.getMemberName()))).build());
            }
            return (B)((Builder)super.id(shapeId));
        }

        public B members(Collection<MemberShape> members) {
            this.clearMembers();
            for (MemberShape member : members) {
                this.addMember(member);
            }
            return (B)this;
        }

        public B clearMembers() {
            this.members.clear();
            return (B)this;
        }

        @Override
        public B addMember(MemberShape member) {
            ((Map)this.members.get()).put(member.getMemberName(), member);
            return (B)this;
        }

        public B addMember(String memberName, ShapeId target) {
            return this.addMember(memberName, target, null);
        }

        public B addMember(String memberName, ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember(memberName));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return (B)this.addMember(builder.build());
        }

        public B removeMember(String member) {
            if (this.members.hasValue()) {
                ((Map)this.members.get()).remove(member);
            }
            return (B)this;
        }

        @Override
        public B addMixin(Shape shape) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before adding a mixin");
            }
            super.addMixin(shape);
            NamedMemberUtils.cleanMixins(shape, (Map)this.members.get());
            return (B)this;
        }

        @Override
        public B removeMixin(ToShapeId shape) {
            super.removeMixin(shape);
            NamedMemberUtils.removeMixin(shape, (Map)this.members.get());
            return (B)this;
        }

        @Override
        public B flattenMixins() {
            if (this.getMixins().isEmpty()) {
                return (B)this;
            }
            this.members(NamedMemberUtils.flattenMixins((Map)this.members.get(), this.getMixins(), this.getId(), this.getSourceLocation()));
            return (B)((Builder)super.flattenMixins());
        }
    }
}

