/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MapShape
extends Shape
implements ToSmithyBuilder<MapShape> {
    private final MemberShape key;
    private final MemberShape value;

    private MapShape(Builder builder) {
        super(builder, false);
        this.key = builder.key != null ? builder.key : this.getRequiredMixinMember(builder, "key");
        this.value = builder.value != null ? builder.value : this.getRequiredMixinMember(builder, "value");
        this.validateMemberShapeIds();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return this.updateBuilder(MapShape.builder()).key(this.key).value(this.value);
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.mapShape(this);
    }

    @Override
    public Optional<MapShape> asMapShape() {
        return Optional.of(this);
    }

    @Override
    public ShapeType getType() {
        return ShapeType.MAP;
    }

    public MemberShape getValue() {
        return this.value;
    }

    public MemberShape getKey() {
        return this.key;
    }

    @Override
    public Collection<MemberShape> members() {
        return ListUtils.of((Object)this.key, (Object)this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        MapShape otherShape = (MapShape)other;
        return super.equals(otherShape) && this.getKey().equals(otherShape.getKey()) && this.getValue().equals(((MapShape)other).getValue());
    }

    public static final class Builder
    extends AbstractShapeBuilder<Builder, MapShape> {
        private MemberShape key;
        private MemberShape value;

        public MapShape build() {
            return new MapShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.MAP;
        }

        @Override
        public Builder id(ShapeId shapeId) {
            if (this.key != null) {
                this.key(((MemberShape.Builder)this.key.toBuilder().id(shapeId.withMember(this.key.getMemberName()))).build());
            }
            if (this.value != null) {
                this.value(((MemberShape.Builder)this.value.toBuilder().id(shapeId.withMember(this.value.getMemberName()))).build());
            }
            return (Builder)super.id(shapeId);
        }

        public Builder key(MemberShape member) {
            this.key = Objects.requireNonNull(member);
            return this;
        }

        public Builder value(MemberShape member) {
            this.value = Objects.requireNonNull(member);
            return this;
        }

        @Override
        public Builder addMember(MemberShape member) {
            if (member.getMemberName().equals("key")) {
                return this.key(member);
            }
            if (member.getMemberName().equals("value")) {
                return this.value(member);
            }
            throw new IllegalStateException("Invalid member given to MapShape builder: " + member.getId());
        }

        public Builder key(ShapeId target) {
            return this.key(target, null);
        }

        public Builder key(ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember("key"));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return this.key(builder.build());
        }

        public Builder value(ShapeId target) {
            return this.value(target, null);
        }

        public Builder value(ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember("value"));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return this.value(builder.build());
        }

        @Override
        public Builder flattenMixins() {
            for (Shape mixin : this.getMixins().values()) {
                for (MemberShape member : mixin.members()) {
                    SourceLocation location = this.getSourceLocation();
                    Collection<Object> localTraits = Collections.emptyList();
                    MemberShape existing = member.getMemberName().equals("key") ? this.key : this.value;
                    if (existing != null) {
                        localTraits = existing.getIntroducedTraits().values();
                        location = existing.getSourceLocation();
                    }
                    this.addMember(((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(this.getId().withMember(member.getMemberName()))).target(member.getTarget()).addTraits(member.getAllTraits().values())).addTraits(localTraits)).source(location)).build());
                }
            }
            return (Builder)super.flattenMixins();
        }
    }
}

