/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.List;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class AndSelector {
    private AndSelector() {
    }

    static InternalSelector of(List<InternalSelector> selectors) {
        switch (selectors.size()) {
            case 0: {
                return InternalSelector.IDENTITY;
            }
            case 1: {
                return selectors.get(0);
            }
            case 2: {
                return (c, s, n) -> ((InternalSelector)selectors.get(0)).push(c, s, (c2, s2) -> ((InternalSelector)selectors.get(1)).push(c2, s2, n));
            }
            case 3: {
                return (c, s, n) -> ((InternalSelector)selectors.get(0)).push(c, s, (c2, s2) -> ((InternalSelector)selectors.get(1)).push(c2, s2, (c3, s3) -> ((InternalSelector)selectors.get(2)).push(c3, s3, n)));
            }
            case 4: {
                return (c, s, n) -> ((InternalSelector)selectors.get(0)).push(c, s, (c2, s2) -> ((InternalSelector)selectors.get(1)).push(c2, s2, (c3, s3) -> ((InternalSelector)selectors.get(2)).push(c3, s3, (c4, s4) -> ((InternalSelector)selectors.get(3)).push(c4, s4, n))));
            }
            case 5: {
                return (c, s, n) -> ((InternalSelector)selectors.get(0)).push(c, s, (c2, s2) -> ((InternalSelector)selectors.get(1)).push(c2, s2, (c3, s3) -> ((InternalSelector)selectors.get(2)).push(c3, s3, (c4, s4) -> ((InternalSelector)selectors.get(3)).push(c4, s4, (c5, s5) -> ((InternalSelector)selectors.get(4)).push(c5, s5, n)))));
            }
            case 6: {
                return (c, s, n) -> ((InternalSelector)selectors.get(0)).push(c, s, (c2, s2) -> ((InternalSelector)selectors.get(1)).push(c2, s2, (c3, s3) -> ((InternalSelector)selectors.get(2)).push(c3, s3, (c4, s4) -> ((InternalSelector)selectors.get(3)).push(c4, s4, (c5, s5) -> ((InternalSelector)selectors.get(4)).push(c5, s5, (c6, s6) -> ((InternalSelector)selectors.get(5)).push(c6, s6, n))))));
            }
            case 7: {
                return (c, s, n) -> ((InternalSelector)selectors.get(0)).push(c, s, (c2, s2) -> ((InternalSelector)selectors.get(1)).push(c2, s2, (c3, s3) -> ((InternalSelector)selectors.get(2)).push(c3, s3, (c4, s4) -> ((InternalSelector)selectors.get(3)).push(c4, s4, (c5, s5) -> ((InternalSelector)selectors.get(4)).push(c5, s5, (c6, s6) -> ((InternalSelector)selectors.get(5)).push(c6, s6, (c7, s7) -> ((InternalSelector)selectors.get(6)).push(c7, s7, n)))))));
            }
        }
        return new RecursiveAndSelector(selectors);
    }

    static final class RecursiveAndSelector
    implements InternalSelector {
        private final List<InternalSelector> selectors;
        private final int terminalSelectorIndex;

        private RecursiveAndSelector(List<InternalSelector> selectors) {
            this.selectors = selectors;
            this.terminalSelectorIndex = this.selectors.size() - 1;
        }

        @Override
        public boolean push(Context context, Shape shape, InternalSelector.Receiver next) {
            return this.selectors.get(0).push(context, shape, new State(1, next));
        }

        private final class State
        implements InternalSelector.Receiver {
            private final int position;
            private final InternalSelector.Receiver downstream;

            private State(int position, InternalSelector.Receiver downstream) {
                this.position = position;
                this.downstream = downstream;
            }

            @Override
            public boolean apply(Context context, Shape shape) {
                if (this.position == RecursiveAndSelector.this.terminalSelectorIndex) {
                    return ((InternalSelector)RecursiveAndSelector.this.selectors.get(this.position)).push(context, shape, this.downstream);
                }
                return ((InternalSelector)RecursiveAndSelector.this.selectors.get(this.position)).push(context, shape, new State(this.position + 1, this.downstream));
            }
        }
    }
}

