/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.MixinTrait;

enum Version {
    UNKNOWN(""),
    VERSION_1_0("1.0"),
    VERSION_2_0("2.0");

    private final String version;

    private Version(String version) {
        this.version = version;
    }

    static Version fromString(String value) {
        switch (value) {
            case "1.0": 
            case "1": {
                return VERSION_1_0;
            }
            case "2": 
            case "2.0": {
                return VERSION_2_0;
            }
        }
        return null;
    }

    public String toString() {
        return this.version;
    }

    boolean supportsMixins() {
        return this == VERSION_2_0;
    }

    boolean supportsInlineOperationIO() {
        return this == VERSION_2_0;
    }

    boolean isShapeTypeSupported(ShapeType shapeType) {
        if (this == VERSION_2_0) {
            return true;
        }
        return shapeType != ShapeType.ENUM && shapeType != ShapeType.INT_ENUM;
    }

    void validateVersionedTrait(ShapeId target, ShapeId traitId, Node value) {
        if (traitId.equals(MixinTrait.ID) && this != VERSION_2_0) {
            throw ModelSyntaxException.builder().message(String.format("Mixins can only be used in Smithy 2.0 or later. Attempted to apply a @mixin trait to `%s` in a model file using version `%s`.", target, this.version)).shapeId(target).sourceLocation(value).build();
        }
    }
}

