/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.MapUtils;

final class ModelUpgrader {
    private static final String UPGRADE_MODEL = "UpgradeModel";
    private static final EnumSet<ShapeType> HAD_DEFAULT_VALUE_IN_1_0 = EnumSet.of(ShapeType.BYTE, new ShapeType[]{ShapeType.SHORT, ShapeType.INTEGER, ShapeType.LONG, ShapeType.FLOAT, ShapeType.DOUBLE, ShapeType.BOOLEAN});
    private static final Map<ShapeId, ShapeId> REMOVED_PRIMITIVE_SHAPES = MapUtils.of((Object)ShapeId.from("smithy.api#PrimitiveBoolean"), (Object)ShapeId.from("smithy.api#Boolean"), (Object)ShapeId.from("smithy.api#PrimitiveByte"), (Object)ShapeId.from("smithy.api#Byte"), (Object)ShapeId.from("smithy.api#PrimitiveShort"), (Object)ShapeId.from("smithy.api#Short"), (Object)ShapeId.from("smithy.api#PrimitiveInteger"), (Object)ShapeId.from("smithy.api#Integer"), (Object)ShapeId.from("smithy.api#PrimitiveLong"), (Object)ShapeId.from("smithy.api#Long"), (Object)ShapeId.from("smithy.api#PrimitiveFloat"), (Object)ShapeId.from("smithy.api#Float"), (Object)ShapeId.from("smithy.api#PrimitiveDouble"), (Object)ShapeId.from("smithy.api#Double"));
    private static final Set<ShapeId> PREVIOUSLY_BOXED = new HashSet<ShapeId>(REMOVED_PRIMITIVE_SHAPES.values());
    private final Model model;
    private final List<ValidationEvent> events;
    private final Map<String, Version> fileToVersion;
    private final List<Shape> shapeUpgrades = new ArrayList<Shape>();

    ModelUpgrader(Model model, List<ValidationEvent> events, Map<String, Version> fileToVersion) {
        this.model = model;
        this.events = events;
        this.fileToVersion = fileToVersion;
    }

    ValidatedResult<Model> transform() {
        for (MemberShape member : this.model.getMemberShapes()) {
            Version version = this.fileToVersion.getOrDefault(member.getSourceLocation().getFilename(), Version.VERSION_2_0);
            if (version == Version.VERSION_1_0) {
                this.model.getShape(member.getContainer()).ifPresent(container -> this.upgradeV1Member(container.getType(), member));
                continue;
            }
            if (version != Version.VERSION_2_0) continue;
            this.validateV2Member(member);
        }
        return new ValidatedResult<Model>(ModelTransformer.create().replaceShapes(this.model, this.shapeUpgrades), this.events);
    }

    private void upgradeV1Member(ShapeType containerType, MemberShape member) {
        Shape target = this.model.getShape(member.getTarget()).orElse(null);
        if (target == null) {
            return;
        }
        MemberShape.Builder builder = null;
        if (REMOVED_PRIMITIVE_SHAPES.containsKey(target.getId())) {
            this.emitWhenTargetingRemovedPreludeShape(Severity.WARNING, member);
            builder = this.createOrReuseBuilder(member, builder);
            builder.target(REMOVED_PRIMITIVE_SHAPES.get(target.getId()));
        }
        if (this.shouldV1MemberHaveDefaultTrait(containerType, member, target)) {
            this.events.add(ValidationEvent.builder().id(UPGRADE_MODEL).severity(Severity.WARNING).shape(member).message("Add the @default trait to this member to make it forward compatible with Smithy IDL 2.0").build());
            builder = this.createOrReuseBuilder(member, builder);
            builder.addTrait(new DefaultTrait(builder.getSourceLocation()));
        }
        if (builder != null) {
            this.shapeUpgrades.add(builder.build());
        }
    }

    private boolean shouldV1MemberHaveDefaultTrait(ShapeType containerType, MemberShape member, Shape target) {
        return containerType == ShapeType.STRUCTURE && HAD_DEFAULT_VALUE_IN_1_0.contains((Object)target.getType()) && !PREVIOUSLY_BOXED.contains(target.getId()) && !member.hasTrait(DefaultTrait.class) && !member.hasTrait(RequiredTrait.class) && !member.hasTrait(BoxTrait.class) && !target.hasTrait(BoxTrait.class);
    }

    private MemberShape.Builder createOrReuseBuilder(MemberShape member, MemberShape.Builder builder) {
        return builder == null ? member.toBuilder() : builder;
    }

    private void validateV2Member(MemberShape member) {
        if (REMOVED_PRIMITIVE_SHAPES.containsKey(member.getTarget())) {
            this.emitWhenTargetingRemovedPreludeShape(Severity.ERROR, member);
        }
        if (member.hasTrait(BoxTrait.class)) {
            this.events.add(ValidationEvent.builder().id(UPGRADE_MODEL).severity(Severity.ERROR).shape(member).sourceLocation(member.expectTrait(BoxTrait.class)).message("@box is not supported in Smithy IDL 2.0").build());
        }
    }

    private void emitWhenTargetingRemovedPreludeShape(Severity severity, MemberShape member) {
        this.events.add(ValidationEvent.builder().id(UPGRADE_MODEL).severity(severity).shape(member).sourceLocation(member).message("This member targets " + member.getTarget() + " which was removed in Smithy IDL " + "2.0" + ". Target " + REMOVED_PRIMITIVE_SHAPES.get(member.getTarget()) + " instead ").build());
    }
}

