/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import software.amazon.smithy.model.loader.PendingShape;
import software.amazon.smithy.model.loader.TraitContainer;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.validation.ValidationEvent;

interface ModelFile {
    public String getFilename();

    public Version getVersion();

    public Set<ShapeId> shapeIds();

    public ShapeType getShapeType(ShapeId var1);

    public Map<String, Node> metadata();

    public TraitContainer resolveShapes(Set<ShapeId> var1, Function<ShapeId, ShapeType> var2);

    public CreatedShapes createShapes(TraitContainer var1);

    public List<ValidationEvent> events();

    public static final class CreatedShapes {
        private final Collection<Shape> shapes;
        private final List<PendingShape> pending;

        CreatedShapes(Collection<Shape> shapes, List<PendingShape> pending) {
            this.shapes = shapes;
            this.pending = pending;
        }

        CreatedShapes(Collection<Shape> shapes) {
            this(shapes, Collections.emptyList());
        }

        Collection<Shape> getCreatedShapes() {
            return this.shapes;
        }

        List<PendingShape> getPendingShapes() {
            return this.pending;
        }
    }
}

