/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.function.Consumer;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.IdlModelParser;
import software.amazon.smithy.model.loader.IdlTextParser;
import software.amazon.smithy.model.loader.ParserUtils;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;

final class IdlNodeParser {
    private static final String SYNTACTIC_SHAPE_ID_TARGET = "SyntacticShapeIdTarget";

    private IdlNodeParser() {
    }

    static Node parseNode(IdlModelParser parser) {
        return IdlNodeParser.parseNode(parser, parser.currentLocation());
    }

    static Node parseNode(IdlModelParser parser, SourceLocation location) {
        char c = parser.peek();
        switch (c) {
            case '{': {
                return IdlNodeParser.parseObjectNode(parser, "object node", location);
            }
            case '[': {
                return IdlNodeParser.parseArrayNode(parser, location);
            }
            case '\"': {
                if (IdlNodeParser.peekTextBlock(parser)) {
                    return IdlNodeParser.parseTextBlock(parser, location);
                }
                return new StringNode(IdlTextParser.parseQuotedString(parser), location);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return parser.parseNumberNode(location);
            }
        }
        return IdlNodeParser.parseNodeTextWithKeywords(parser, location, ParserUtils.parseShapeId(parser));
    }

    static Node parseNodeTextWithKeywords(IdlModelParser parser, SourceLocation location, String text) {
        switch (text) {
            case "true": {
                return new BooleanNode(true, location);
            }
            case "false": {
                return new BooleanNode(false, location);
            }
            case "null": {
                return new NullNode(location);
            }
        }
        Pair<StringNode, Consumer<String>> pair = StringNode.createLazyString(text, location);
        Consumer consumer = (Consumer)pair.right;
        parser.modelFile.addForwardReference(text, (id, typeFunction) -> {
            if (typeFunction.apply(id) == null) {
                parser.modelFile.events().add(ValidationEvent.builder().id(SYNTACTIC_SHAPE_ID_TARGET).severity(Severity.DANGER).message(String.format("Syntactic shape ID `%s` does not resolve to a valid shape ID: `%s`. Did you mean to quote this string? Are you missing a model file?", text, id)).sourceLocation(location).build());
            }
            consumer.accept(id.toString());
        });
        return (Node)pair.left;
    }

    static boolean peekTextBlock(IdlModelParser parser) {
        return parser.peek() == '\"' && parser.peek(1) == '\"' && parser.peek(2) == '\"';
    }

    static Node parseTextBlock(IdlModelParser parser, SourceLocation location) {
        parser.expect('\"');
        parser.expect('\"');
        parser.expect('\"');
        return new StringNode(IdlTextParser.parseQuotedTextAndTextBlock(parser, true), location);
    }

    static ObjectNode parseObjectNode(IdlModelParser parser, String parent) {
        return IdlNodeParser.parseObjectNode(parser, parent, parser.currentLocation());
    }

    static ObjectNode parseObjectNode(IdlModelParser parser, String parent, SourceLocation location) {
        char c;
        parser.increaseNestingLevel();
        ObjectNode.Builder builder = ObjectNode.builder().sourceLocation(location);
        parser.expect('{');
        parser.ws();
        while (!parser.eof() && (c = parser.peek()) != '}') {
            SourceLocation keyLocation = parser.currentLocation();
            String key = IdlNodeParser.parseNodeObjectKey(parser);
            parser.ws();
            parser.expect(':');
            if (parser.peek() == '=') {
                throw parser.syntax("The `:=` syntax may only be used when defining inline operation input and output shapes.");
            }
            parser.ws();
            Node value = IdlNodeParser.parseNode(parser);
            StringNode keyNode = new StringNode(key, keyLocation);
            if (builder.hasMember(key)) {
                throw parser.syntax("Duplicate member of " + parent + ": '" + keyNode.getValue() + '\'');
            }
            builder.withMember(keyNode, value);
            parser.ws();
        }
        parser.expect('}');
        parser.decreaseNestingLevel();
        return builder.build();
    }

    static String parseNodeObjectKey(IdlModelParser parser) {
        if (parser.peek() == '\"') {
            return IdlTextParser.parseQuotedString(parser);
        }
        return ParserUtils.parseIdentifier(parser);
    }

    private static ArrayNode parseArrayNode(IdlModelParser parser, SourceLocation location) {
        char c;
        parser.increaseNestingLevel();
        ArrayNode.Builder builder = ArrayNode.builder().sourceLocation(location);
        parser.expect('[');
        parser.ws();
        while (!parser.eof() && (c = parser.peek()) != ']') {
            builder.withValue(IdlNodeParser.parseNode(parser));
            parser.ws();
        }
        parser.expect(']');
        parser.decreaseNestingLevel();
        return builder.build();
    }
}

