/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.AbstractMutableModelFile;
import software.amazon.smithy.model.loader.TraitContainer;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitFactory;

final class FullyResolvedModelFile
extends AbstractMutableModelFile {
    FullyResolvedModelFile(String filename, TraitFactory traitFactory) {
        super(filename, traitFactory);
    }

    static FullyResolvedModelFile fromShapes(TraitFactory traitFactory, Collection<Shape> shapes) {
        return FullyResolvedModelFile.fromShapes(traitFactory, shapes, null);
    }

    static FullyResolvedModelFile fromShapes(TraitFactory traitFactory, Collection<Shape> shapes, Version version) {
        FullyResolvedModelFile modelFile = new FullyResolvedModelFile(SourceLocation.none().getFilename(), traitFactory);
        if (version != null) {
            modelFile.setVersion(version);
        }
        for (Shape shape : shapes) {
            Object builder = ((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).clearTraits();
            modelFile.onShape((AbstractShapeBuilder<?, ?>)builder);
            for (Trait trait : shape.getAllTraits().values()) {
                modelFile.onTrait(shape.getId(), trait);
            }
        }
        return modelFile;
    }

    @Override
    public TraitContainer resolveShapes(Set<ShapeId> shapeIds, Function<ShapeId, ShapeType> typeProvider) {
        return this.traitContainer;
    }
}

